/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.expressiontransforms;

import com.yahoo.path.Path;
import com.yahoo.searchdefinition.expressiontransforms.ConvertedModel;
import com.yahoo.searchdefinition.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import com.yahoo.searchlib.rankingexpression.transform.TransformContext;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;

public class TensorFlowFeatureConverter
extends ExpressionTransformer<RankProfileTransformContext> {
    private final Map<Path, ConvertedModel> convertedTensorFlowModels = new HashMap<Path, ConvertedModel>();

    public ExpressionNode transform(ExpressionNode node, RankProfileTransformContext context) {
        if (node instanceof ReferenceNode) {
            return this.transformFeature((ReferenceNode)node, context);
        }
        if (node instanceof CompositeNode) {
            return super.transformChildren((CompositeNode)node, (TransformContext)context);
        }
        return node;
    }

    private ExpressionNode transformFeature(ReferenceNode feature, RankProfileTransformContext context) {
        if (!feature.getName().equals("tensorflow")) {
            return feature;
        }
        try {
            Path modelPath = Path.fromString((String)ConvertedModel.FeatureArguments.asString((ExpressionNode)feature.getArguments().expressions().get(0)));
            ConvertedModel convertedModel = this.convertedTensorFlowModels.computeIfAbsent(modelPath, __ -> new ConvertedModel(modelPath, context));
            return convertedModel.expression(this.asFeatureArguments(feature.getArguments()));
        }
        catch (UncheckedIOException | IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not use tensorflow model from " + feature, e);
        }
    }

    private ConvertedModel.FeatureArguments asFeatureArguments(Arguments arguments) {
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException("A tensorflow node must take an argument pointing to the tensorflow model directory under [application]/models");
        }
        if (arguments.expressions().size() > 3) {
            throw new IllegalArgumentException("A tensorflow feature can have at most 3 arguments");
        }
        return new ConvertedModel.FeatureArguments(arguments);
    }
}

