/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.expressiontransforms;

import com.yahoo.collections.Pair;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.io.IOUtils;
import com.yahoo.path.Path;
import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchdefinition.FeatureNames;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankingConstant;
import com.yahoo.searchdefinition.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.integration.ml.ImportedModel;
import com.yahoo.searchlib.rankingexpression.integration.ml.ImportedModels;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.rule.Arguments;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.GeneratorLambdaFunctionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import com.yahoo.tensor.functions.Generate;
import com.yahoo.tensor.functions.Join;
import com.yahoo.tensor.functions.Reduce;
import com.yahoo.tensor.functions.Rename;
import com.yahoo.tensor.functions.ScalarFunctions;
import com.yahoo.tensor.functions.TensorFunction;
import com.yahoo.tensor.serialization.TypedBinaryFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConvertedModel {
    private final String modelName;
    private final Path modelPath;
    private final Map<String, RankingExpression> expressions;

    public ConvertedModel(Path modelPath, RankProfileTransformContext context) {
        this.modelPath = modelPath;
        this.modelName = ConvertedModel.toModelName(modelPath);
        ModelStore store = new ModelStore(context.rankProfile().applicationPackage(), modelPath);
        this.expressions = store.hasSourceModel() ? this.convertModel(store, context.rankProfile(), context.queryProfiles(), context.importedModels()) : this.transformFromStoredModel(store, context.rankProfile());
    }

    private Map<String, RankingExpression> convertModel(ModelStore store, RankProfile profile, QueryProfileRegistry queryProfiles, ImportedModels importedModels) {
        ImportedModel model = importedModels.get(store.sourceModelFile());
        return this.transformFromImportedModel(model, store, profile, queryProfiles);
    }

    public ExpressionNode expression(FeatureArguments arguments) {
        if (this.expressions.isEmpty()) {
            throw new IllegalArgumentException("No expressions available in " + this);
        }
        RankingExpression expression = this.expressions.get(arguments.toName());
        if (expression != null) {
            return expression.getRoot();
        }
        if (!arguments.signature().isPresent()) {
            if (this.expressions.size() > 1) {
                throw new IllegalArgumentException("Multiple candidate expressions " + this.missingExpressionMessageSuffix());
            }
            return this.expressions.values().iterator().next().getRoot();
        }
        if (!arguments.output().isPresent()) {
            List entriesWithTheRightPrefix = this.expressions.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(arguments.signature().get() + ".")).collect(Collectors.toList());
            if (entriesWithTheRightPrefix.size() < 1) {
                throw new IllegalArgumentException("No expressions named '" + arguments.signature().get() + this.missingExpressionMessageSuffix());
            }
            if (entriesWithTheRightPrefix.size() > 1) {
                throw new IllegalArgumentException("Multiple candidate expression named '" + arguments.signature().get() + this.missingExpressionMessageSuffix());
            }
            return ((RankingExpression)((Map.Entry)entriesWithTheRightPrefix.get(0)).getValue()).getRoot();
        }
        throw new IllegalArgumentException("No expression '" + arguments.toName() + this.missingExpressionMessageSuffix());
    }

    private String missingExpressionMessageSuffix() {
        return "' in model '" + this.modelPath + "'. Available expressions: " + this.expressions.keySet().stream().collect(Collectors.joining(", "));
    }

    private Map<String, RankingExpression> transformFromImportedModel(ImportedModel model, ModelStore store, RankProfile profile, QueryProfileRegistry queryProfiles) {
        HashSet<String> constantsReplacedByMacros = new HashSet<String>();
        model.smallConstants().forEach((k, v) -> this.transformSmallConstant(store, profile, (String)k, (Tensor)v));
        model.largeConstants().forEach((k, v) -> this.transformLargeConstant(store, profile, queryProfiles, (Set<String>)constantsReplacedByMacros, (String)k, (Tensor)v));
        this.addGeneratedMacros(model, profile);
        HashMap<String, RankingExpression> expressions = new HashMap<String, RankingExpression>();
        for (Pair output : model.outputExpressions()) {
            this.addExpression((RankingExpression)output.getSecond(), (String)output.getFirst(), constantsReplacedByMacros, model, store, profile, queryProfiles, expressions);
        }
        model.macros().forEach((k, v) -> this.transformGeneratedMacro(store, (Set<String>)constantsReplacedByMacros, (String)k, profile.getMacros().get(k).getRankingExpression()));
        return expressions;
    }

    private void addExpression(RankingExpression expression, String expressionName, Set<String> constantsReplacedByMacros, ImportedModel model, ModelStore store, RankProfile profile, QueryProfileRegistry queryProfiles, Map<String, RankingExpression> expressions) {
        expression = this.replaceConstantsByMacros(expression, constantsReplacedByMacros);
        this.verifyRequiredMacros(expression, model, profile, queryProfiles);
        this.reduceBatchDimensions(expression, model, profile, queryProfiles);
        store.writeExpression(expressionName, expression);
        expressions.put(expressionName, expression);
    }

    private Map<String, RankingExpression> transformFromStoredModel(ModelStore store, RankProfile profile) {
        for (Pair pair : store.readSmallConstants()) {
            profile.addConstant((String)pair.getFirst(), this.asValue((Tensor)pair.getSecond()));
        }
        for (RankingConstant rankingConstant : store.readLargeConstants()) {
            if (profile.rankingConstants().asMap().containsKey(rankingConstant.getName())) continue;
            profile.rankingConstants().add(rankingConstant);
        }
        for (Pair pair : store.readMacros()) {
            this.addGeneratedMacroToProfile(profile, (String)pair.getFirst(), (RankingExpression)pair.getSecond());
        }
        return store.readExpressions();
    }

    private void transformSmallConstant(ModelStore store, RankProfile profile, String constantName, Tensor constantValue) {
        store.writeSmallConstant(constantName, constantValue);
        profile.addConstant(constantName, this.asValue(constantValue));
    }

    private void transformLargeConstant(ModelStore store, RankProfile profile, QueryProfileRegistry queryProfiles, Set<String> constantsReplacedByMacros, String constantName, Tensor constantValue) {
        RankProfile.Macro macroOverridingConstant = profile.getMacros().get(constantName);
        if (macroOverridingConstant != null) {
            TensorType macroType = macroOverridingConstant.getRankingExpression().type(profile.typeContext(queryProfiles));
            if (!macroType.equals((Object)constantValue.type())) {
                throw new IllegalArgumentException("Macro '" + constantName + "' replaces the constant with this name. " + this.typeMismatchExplanation(constantValue.type(), macroType));
            }
            constantsReplacedByMacros.add(constantName);
        } else {
            Path constantPath = store.writeLargeConstant(constantName, constantValue);
            if (!profile.rankingConstants().asMap().containsKey(constantName)) {
                profile.rankingConstants().add(new RankingConstant(constantName, constantValue.type(), constantPath.toString()));
            }
        }
    }

    private void transformGeneratedMacro(ModelStore store, Set<String> constantsReplacedByMacros, String macroName, RankingExpression expression) {
        expression = this.replaceConstantsByMacros(expression, constantsReplacedByMacros);
        store.writeMacro(macroName, expression);
    }

    private void addGeneratedMacroToProfile(RankProfile profile, String macroName, RankingExpression expression) {
        if (profile.getMacros().containsKey(macroName)) {
            if (!profile.getMacros().get(macroName).getRankingExpression().equals((Object)expression)) {
                throw new IllegalArgumentException("Generated macro '" + macroName + "' already exists in " + profile + " - with a different definition");
            }
            return;
        }
        profile.addMacro(macroName, false);
        RankProfile.Macro macro = profile.getMacros().get(macroName);
        macro.setRankingExpression(expression);
        macro.setTextualExpression(expression.getRoot().toString());
    }

    private void verifyRequiredMacros(RankingExpression expression, ImportedModel model, RankProfile profile, QueryProfileRegistry queryProfiles) {
        HashSet<String> macroNames = new HashSet<String>();
        this.addMacroNamesIn(expression.getRoot(), macroNames, model);
        for (String macroName : macroNames) {
            TensorType requiredType = (TensorType)model.requiredMacros().get(macroName);
            if (requiredType == null) continue;
            RankProfile.Macro macro = profile.getMacros().get(macroName);
            if (macro == null) {
                throw new IllegalArgumentException("Model refers input '" + macroName + "' of type " + requiredType + " but this macro is not present in " + profile);
            }
            TensorType actualType = macro.getRankingExpression().getRoot().type(profile.typeContext(queryProfiles));
            if (actualType == null) {
                throw new IllegalArgumentException("Model refers input '" + macroName + "' of type " + requiredType + " which must be produced by a macro in the rank profile, but this macro references a feature which is not declared");
            }
            if (actualType.isAssignableTo(requiredType)) continue;
            throw new IllegalArgumentException("Model refers input '" + macroName + "'. " + this.typeMismatchExplanation(requiredType, actualType));
        }
    }

    private String typeMismatchExplanation(TensorType requiredType, TensorType actualType) {
        return "The required type of this is " + requiredType + ", but this macro returns " + actualType + (actualType.rank() == 0 ? ". This is often due to missing declaration of query tensor features in query profile types - see the documentation." : "");
    }

    private void addGeneratedMacros(ImportedModel model, RankProfile profile) {
        model.macros().forEach((k, v) -> this.addGeneratedMacroToProfile(profile, (String)k, v.copy()));
    }

    private void reduceBatchDimensions(RankingExpression expression, ImportedModel model, RankProfile profile, QueryProfileRegistry queryProfiles) {
        TypeContext<Reference> typeContext = profile.typeContext(queryProfiles);
        TensorType typeBeforeReducing = expression.getRoot().type(typeContext);
        HashSet<String> macroNames = new HashSet<String>();
        this.addMacroNamesIn(expression.getRoot(), macroNames, model);
        for (String macroName : macroNames) {
            if (!model.macros().containsKey(macroName)) continue;
            RankProfile.Macro macro = profile.getMacros().get(macroName);
            if (macro == null) {
                throw new IllegalArgumentException("Model refers to generated macro '" + macroName + "but this macro is not present in " + profile);
            }
            RankingExpression macroExpression = macro.getRankingExpression();
            macroExpression.setRoot(this.reduceBatchDimensionsAtInput(macroExpression.getRoot(), model, typeContext));
        }
        ExpressionNode root = expression.getRoot();
        root = this.reduceBatchDimensionsAtInput(root, model, typeContext);
        TensorType typeAfterReducing = root.type(typeContext);
        root = this.expandBatchDimensionsAtOutput(root, typeBeforeReducing, typeAfterReducing);
        expression.setRoot(root);
    }

    private ExpressionNode reduceBatchDimensionsAtInput(ExpressionNode node, ImportedModel model, TypeContext<Reference> typeContext) {
        List children;
        TensorFunction tensorFunction;
        if (node instanceof TensorFunctionNode && (tensorFunction = ((TensorFunctionNode)node).function()) instanceof Rename && (children = ((TensorFunctionNode)node).children()).size() == 1 && children.get(0) instanceof ReferenceNode) {
            ReferenceNode referenceNode = (ReferenceNode)children.get(0);
            if (model.requiredMacros().containsKey(referenceNode.getName())) {
                return this.reduceBatchDimensionExpression(tensorFunction, typeContext);
            }
        }
        if (node instanceof ReferenceNode) {
            ReferenceNode referenceNode = (ReferenceNode)node;
            if (model.requiredMacros().containsKey(referenceNode.getName())) {
                return this.reduceBatchDimensionExpression((TensorFunction)TensorFunctionNode.wrapArgument((ExpressionNode)node), typeContext);
            }
        }
        if (node instanceof CompositeNode) {
            List children2 = ((CompositeNode)node).children();
            ArrayList<ExpressionNode> transformedChildren = new ArrayList<ExpressionNode>(children2.size());
            for (ExpressionNode child : children2) {
                transformedChildren.add(this.reduceBatchDimensionsAtInput(child, model, typeContext));
            }
            return ((CompositeNode)node).setChildren(transformedChildren);
        }
        return node;
    }

    private ExpressionNode reduceBatchDimensionExpression(TensorFunction function, TypeContext<Reference> context) {
        TensorFunction result = function;
        TensorType type = function.type(context);
        if (type.dimensions().size() > 1) {
            ArrayList<String> reduceDimensions = new ArrayList<String>();
            for (TensorType.Dimension dimension : type.dimensions()) {
                if (dimension.size().orElse(-1L) != 1L) continue;
                reduceDimensions.add(dimension.name());
            }
            if (reduceDimensions.size() > 0) {
                result = new Reduce(function, Reduce.Aggregator.sum, reduceDimensions);
            }
        }
        return new TensorFunctionNode(result);
    }

    private ExpressionNode expandBatchDimensionsAtOutput(ExpressionNode node, TensorType before, TensorType after) {
        if (after.equals((Object)before)) {
            return node;
        }
        TensorType.Builder typeBuilder = new TensorType.Builder();
        for (TensorType.Dimension dimension : before.dimensions()) {
            if (dimension.size().orElse(-1L) != 1L || after.dimensionNames().contains(dimension.name())) continue;
            typeBuilder.indexed(dimension.name(), 1L);
        }
        TensorType expandDimensionsType = typeBuilder.build();
        if (expandDimensionsType.dimensions().size() > 0) {
            ConstantNode generatedExpression = new ConstantNode((Value)new DoubleValue(1.0));
            Generate generatedFunction = new Generate(expandDimensionsType, (Function)new GeneratorLambdaFunctionNode(expandDimensionsType, (ExpressionNode)generatedExpression).asLongListToDoubleOperator());
            Join expand = new Join((TensorFunction)TensorFunctionNode.wrapArgument((ExpressionNode)node), (TensorFunction)generatedFunction, ScalarFunctions.multiply());
            return new TensorFunctionNode((TensorFunction)expand);
        }
        return node;
    }

    private RankingExpression replaceConstantsByMacros(RankingExpression expression, Set<String> constantsReplacedByMacros) {
        if (constantsReplacedByMacros.isEmpty()) {
            return expression;
        }
        return new RankingExpression(expression.getName(), this.replaceConstantsByMacros(expression.getRoot(), constantsReplacedByMacros));
    }

    private ExpressionNode replaceConstantsByMacros(ExpressionNode node, Set<String> constantsReplacedByMacros) {
        String argument;
        Reference reference;
        if (node instanceof ReferenceNode && FeatureNames.isSimpleFeature(reference = ((ReferenceNode)node).reference()) && reference.name().equals("constant") && constantsReplacedByMacros.contains(argument = (String)reference.simpleArgument().get())) {
            return new ReferenceNode(argument);
        }
        if (node instanceof CompositeNode) {
            CompositeNode composite = (CompositeNode)node;
            return composite.setChildren(composite.children().stream().map(child -> this.replaceConstantsByMacros((ExpressionNode)child, constantsReplacedByMacros)).collect(Collectors.toList()));
        }
        return node;
    }

    private void addMacroNamesIn(ExpressionNode node, Set<String> names, ImportedModel model) {
        block3: {
            block2: {
                if (!(node instanceof ReferenceNode)) break block2;
                ReferenceNode referenceNode = (ReferenceNode)node;
                if (referenceNode.getOutput() != null) break block3;
                names.add(referenceNode.getName());
                if (!model.macros().containsKey(referenceNode.getName())) break block3;
                this.addMacroNamesIn(((RankingExpression)model.macros().get(referenceNode.getName())).getRoot(), names, model);
                break block3;
            }
            if (node instanceof CompositeNode) {
                for (ExpressionNode child : ((CompositeNode)node).children()) {
                    this.addMacroNamesIn(child, names, model);
                }
            }
        }
    }

    private Value asValue(Tensor tensor) {
        if (tensor.type().rank() == 0) {
            return new DoubleValue(tensor.asDouble());
        }
        return new TensorValue(tensor);
    }

    private static String toModelName(Path modelPath) {
        return modelPath.toString().replace("/", "_");
    }

    public String toString() {
        return "model '" + this.modelName + "'";
    }

    static class FeatureArguments {
        private final String modelName;
        private final Path modelPath;
        private final Optional<String> signature;
        private final Optional<String> output;

        public FeatureArguments(Arguments arguments) {
            this(Path.fromString((String)FeatureArguments.asString((ExpressionNode)arguments.expressions().get(0))), FeatureArguments.optionalArgument(1, arguments), FeatureArguments.optionalArgument(2, arguments));
        }

        public FeatureArguments(Path modelPath, Optional<String> signature, Optional<String> output) {
            this.modelPath = modelPath;
            this.modelName = ConvertedModel.toModelName(modelPath);
            this.signature = signature;
            this.output = output;
        }

        public Path modelPath() {
            return this.modelPath;
        }

        public Optional<String> signature() {
            return this.signature;
        }

        public Optional<String> output() {
            return this.output;
        }

        public String toName() {
            return (this.signature.isPresent() ? this.signature.get() : "") + (this.output.isPresent() ? "." + this.output.get() : "");
        }

        private static Optional<String> optionalArgument(int argumentIndex, Arguments arguments) {
            if (argumentIndex >= arguments.expressions().size()) {
                return Optional.empty();
            }
            return Optional.of(FeatureArguments.asString((ExpressionNode)arguments.expressions().get(argumentIndex)));
        }

        public static String asString(ExpressionNode node) {
            if (!(node instanceof ConstantNode)) {
                throw new IllegalArgumentException("Expected a constant string as argument, but got '" + node);
            }
            return FeatureArguments.stripQuotes(((ConstantNode)node).sourceString());
        }

        private static String stripQuotes(String s) {
            if (!FeatureArguments.isQuoteSign(s.codePointAt(0))) {
                return s;
            }
            if (!FeatureArguments.isQuoteSign(s.codePointAt(s.length() - 1))) {
                throw new IllegalArgumentException("argument [" + s + "] is missing endquote");
            }
            return s.substring(1, s.length() - 1);
        }

        private static boolean isQuoteSign(int c) {
            return c == 39 || c == 34;
        }
    }

    static class ModelFiles {
        Path modelPath;

        public ModelFiles(Path modelPath) {
            this.modelPath = modelPath;
        }

        public String modelName() {
            return this.modelPath.toString().replace('/', '_').replace('.', '_');
        }

        public Path modelPath() {
            return this.modelPath;
        }

        public Path storedModelReplicatedPath() {
            return ApplicationPackage.MODELS_GENERATED_REPLICATED_DIR.append(this.modelPath());
        }

        public Path storedModelPath() {
            return ApplicationPackage.MODELS_GENERATED_DIR.append(this.modelPath());
        }

        public Path expressionPath(String name) {
            return this.expressionsPath().append(name);
        }

        public Path expressionsPath() {
            return this.storedModelReplicatedPath().append("expressions");
        }

        public Path smallConstantsPath() {
            return this.storedModelPath().append("constants.txt");
        }

        public Path largeConstantsPath() {
            return this.storedModelReplicatedPath().append("constants");
        }

        public Path macrosPath() {
            return this.storedModelReplicatedPath().append("macros.txt");
        }
    }

    static class ModelStore {
        private final ApplicationPackage application;
        private final ModelFiles modelFiles;

        ModelStore(ApplicationPackage application, Path modelPath) {
            this.application = application;
            this.modelFiles = new ModelFiles(modelPath);
        }

        public boolean hasSourceModel() {
            return this.sourceModelFile().exists();
        }

        public File sourceModelFile() {
            return this.application.getFileReference(ApplicationPackage.MODELS_DIR.append(this.modelFiles.modelPath()));
        }

        void writeExpression(String name, RankingExpression expression) {
            this.application.getFile(this.modelFiles.expressionPath(name)).writeFile((Reader)new StringReader(expression.getRoot().toString()));
        }

        Map<String, RankingExpression> readExpressions() {
            HashMap<String, RankingExpression> expressions = new HashMap<String, RankingExpression>();
            ApplicationFile expressionPath = this.application.getFile(this.modelFiles.expressionsPath());
            if (!expressionPath.exists() || !expressionPath.isDirectory()) {
                return Collections.emptyMap();
            }
            for (ApplicationFile expressionFile : expressionPath.listFiles()) {
                try {
                    BufferedReader reader = new BufferedReader(expressionFile.createReader());
                    Throwable throwable = null;
                    try {
                        String name = expressionFile.getPath().getName();
                        expressions.put(name, new RankingExpression(name, (Reader)reader));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed reading " + expressionFile.getPath(), e);
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Invalid stored expression in " + expressionFile, e);
                }
            }
            return expressions;
        }

        void writeMacro(String name, RankingExpression expression) {
            this.application.getFile(this.modelFiles.macrosPath()).appendFile(name + "\t" + expression.getRoot().toString() + "\n");
        }

        List<Pair<String, RankingExpression>> readMacros() {
            try {
                String line;
                ApplicationFile file = this.application.getFile(this.modelFiles.macrosPath());
                if (!file.exists()) {
                    return Collections.emptyList();
                }
                ArrayList<Pair<String, RankingExpression>> macros = new ArrayList<Pair<String, RankingExpression>>();
                BufferedReader reader = new BufferedReader(file.createReader());
                while (null != (line = reader.readLine())) {
                    String[] parts = line.split("\t");
                    String name = parts[0];
                    try {
                        RankingExpression expression = new RankingExpression(parts[1]);
                        macros.add((Pair<String, RankingExpression>)new Pair((Object)name, (Object)expression));
                    }
                    catch (ParseException e) {
                        throw new IllegalStateException("Could not parse " + name, e);
                    }
                }
                return macros;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        List<RankingConstant> readLargeConstants() {
            try {
                ArrayList<RankingConstant> constants = new ArrayList<RankingConstant>();
                for (ApplicationFile constantFile : this.application.getFile(this.modelFiles.largeConstantsPath()).listFiles()) {
                    String[] parts = IOUtils.readAll((Reader)constantFile.createReader()).split(":");
                    constants.add(new RankingConstant(parts[0], TensorType.fromSpec((String)parts[1]), parts[2]));
                }
                return constants;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        Path writeLargeConstant(String name, Tensor constant) {
            Path constantsPath = ApplicationPackage.MODELS_GENERATED_DIR.append(this.modelFiles.modelPath()).append("constants");
            Path constantPath = constantsPath.append(name + ".tbf");
            this.application.getFile(this.modelFiles.largeConstantsPath().append(name + ".constant")).writeFile((Reader)new StringReader(name + ":" + constant.type() + ":" + this.correct(constantPath)));
            this.createIfNeeded(constantsPath);
            IOUtils.writeFile((File)this.application.getFileReference(constantPath), (byte[])TypedBinaryFormat.encode((Tensor)constant));
            return this.correct(constantPath);
        }

        private List<Pair<String, Tensor>> readSmallConstants() {
            try {
                String line;
                ApplicationFile file = this.application.getFile(this.modelFiles.smallConstantsPath());
                if (!file.exists()) {
                    return Collections.emptyList();
                }
                ArrayList<Pair<String, Tensor>> constants = new ArrayList<Pair<String, Tensor>>();
                BufferedReader reader = new BufferedReader(file.createReader());
                while (null != (line = reader.readLine())) {
                    String[] parts = line.split("\t");
                    String name = parts[0];
                    TensorType type = TensorType.fromSpec((String)parts[1]);
                    Tensor tensor = Tensor.from((TensorType)type, (String)parts[2]);
                    constants.add((Pair<String, Tensor>)new Pair((Object)name, (Object)tensor));
                }
                return constants;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public void writeSmallConstant(String name, Tensor constant) {
            this.application.getFile(this.modelFiles.smallConstantsPath()).appendFile(name + "\t" + constant.type().toString() + "\t" + constant.toString() + "\n");
        }

        private Path correct(Path path) {
            if (this.application.getFileReference(Path.fromString((String)"")).getAbsolutePath().endsWith(".preprocessed") && !path.elements().contains(".preprocessed")) {
                return Path.fromString((String)".preprocessed").append(path);
            }
            return path;
        }

        private void createIfNeeded(Path path) {
            File dir = this.application.getFileReference(path);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IllegalStateException("Could not create " + dir);
            }
        }

        private void close(Reader reader) {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

