/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.search.query.profile.QueryProfileRegistry;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.derived.RawRankProfile;
import com.yahoo.searchlib.rankingexpression.integration.ml.ImportedModels;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import java.util.LinkedHashMap;
import java.util.Map;

public class RankProfileList
extends Derived
implements RankProfilesConfig.Producer {
    private final Map<String, RawRankProfile> rankProfiles = new LinkedHashMap<String, RawRankProfile>();
    public static RankProfileList empty = new RankProfileList();

    private RankProfileList() {
    }

    public RankProfileList(Search search, AttributeFields attributeFields, RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfiles, ImportedModels importedModels) {
        this.setName(search == null ? "default" : search.getName());
        this.deriveRankProfiles(rankProfileRegistry, queryProfiles, importedModels, search, attributeFields);
    }

    private void deriveRankProfiles(RankProfileRegistry rankProfileRegistry, QueryProfileRegistry queryProfiles, ImportedModels importedModels, Search search, AttributeFields attributeFields) {
        if (search != null) {
            RawRankProfile defaultProfile = new RawRankProfile(rankProfileRegistry.get(search, "default"), queryProfiles, importedModels, attributeFields);
            this.rankProfiles.put(defaultProfile.getName(), defaultProfile);
        }
        for (RankProfile rank : rankProfileRegistry.rankProfilesOf(search)) {
            if (search != null && "default".equals(rank.getName())) continue;
            RawRankProfile rawRank = new RawRankProfile(rank, queryProfiles, importedModels, attributeFields);
            this.rankProfiles.put(rawRank.getName(), rawRank);
        }
    }

    public Map<String, RawRankProfile> getRankProfiles() {
        return this.rankProfiles;
    }

    public RawRankProfile getRankProfile(String name) {
        return this.rankProfiles.get(name);
    }

    @Override
    public String getDerivedName() {
        return "rank-profiles";
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        for (RawRankProfile rank : this.rankProfiles.values()) {
            rank.getConfig(builder);
        }
    }
}

