/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.yahoo.vespa.model.content.Redundancy;
import com.yahoo.vespa.model.content.StorageGroup;
import com.yahoo.vespa.model.content.StorageNode;
import com.yahoo.vespa.model.content.TuningDispatch;
import java.util.List;
import java.util.stream.Collectors;

public class IndexedHierarchicDistributionValidator {
    private final String clusterName;
    private final StorageGroup rootGroup;
    private final Redundancy redundancy;
    private final TuningDispatch.DispatchPolicy dispatchPolicy;

    public IndexedHierarchicDistributionValidator(String clusterName, StorageGroup rootGroup, Redundancy redundancy, TuningDispatch.DispatchPolicy dispatchPolicy) {
        this.clusterName = clusterName;
        this.rootGroup = rootGroup;
        this.redundancy = redundancy;
        this.dispatchPolicy = dispatchPolicy;
    }

    public void validate() throws Exception {
        this.validateThatWeHaveOneGroupLevel();
        this.validateThatLeafGroupsHasEqualNumberOfNodes();
        this.validateThatLeafGroupsCountIsAFactorOfRedundancy();
        this.validateThatRedundancyPerGroupIsEqual();
        this.validateThatReadyCopiesIsCompatibleWithRedundancy(this.rootGroup.getSubgroups().size());
    }

    private void validateThatWeHaveOneGroupLevel() {
        for (StorageGroup group : this.rootGroup.getSubgroups()) {
            if (group.getSubgroups().size() <= 0) continue;
            throw new IllegalArgumentException(this.getErrorMsgPrefix() + "Expected all groups under root group '" + this.rootGroup.getName() + "' to be leaf groups only containing nodes, but sub group '" + group.getName() + "' contains " + group.getSubgroups().size() + " sub groups.");
        }
    }

    private void validateThatLeafGroupsHasEqualNumberOfNodes() {
        if (this.dispatchPolicy != TuningDispatch.DispatchPolicy.ROUNDROBIN) {
            return;
        }
        StorageGroup previousGroup = null;
        for (StorageGroup group : this.rootGroup.getSubgroups()) {
            if (previousGroup == null) {
                previousGroup = group;
                continue;
            }
            if (group.getNodes().size() != previousGroup.getNodes().size()) {
                throw new IllegalArgumentException(this.getErrorMsgPrefix() + "Expected leaf groups to contain an equal number of nodes, but leaf group '" + previousGroup.getName() + "' contains " + previousGroup.getNodes().size() + " node(s) while leaf group '" + group.getName() + "' contains " + group.getNodes().size() + " node(s).");
            }
            previousGroup = group;
        }
    }

    private void validateThatLeafGroupsCountIsAFactorOfRedundancy() {
        if (this.redundancy.effectiveFinalRedundancy() % this.rootGroup.getSubgroups().size() != 0) {
            throw new IllegalArgumentException(this.getErrorMsgPrefix() + "Expected number of leaf groups (" + this.rootGroup.getSubgroups().size() + ") to be a factor of redundancy (" + this.redundancy.effectiveFinalRedundancy() + "), but it is not.");
        }
    }

    private void validateThatRedundancyPerGroupIsEqual() {
        int redundancyPerGroup = this.redundancy.effectiveFinalRedundancy() / this.rootGroup.getSubgroups().size();
        String expPartitions = this.createDistributionPartitions(redundancyPerGroup, this.rootGroup.getSubgroups().size());
        if (!this.rootGroup.getPartitions().get().equals(expPartitions)) {
            throw new IllegalArgumentException(this.getErrorMsgPrefix() + "Expected redundancy per leaf group to be " + redundancyPerGroup + ", but it is not according to distribution partitions '" + this.rootGroup.getPartitions().get() + "'. Expected distribution partitions should be '" + expPartitions + "'.");
        }
    }

    private List<StorageNode> nonRetired(List<StorageNode> nodes) {
        return nodes.stream().filter(node -> !node.isRetired()).collect(Collectors.toList());
    }

    private String createDistributionPartitions(int redundancyPerGroup, int numGroups) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numGroups - 1; ++i) {
            sb.append(redundancyPerGroup);
            sb.append("|");
        }
        sb.append("*");
        return sb.toString();
    }

    private void validateThatReadyCopiesIsCompatibleWithRedundancy(int groupCount) throws Exception {
        if (this.redundancy.effectiveFinalRedundancy() % groupCount != 0) {
            throw new Exception(this.getErrorMsgPrefix() + "Expected equal redundancy per group.");
        }
        if (this.redundancy.effectiveReadyCopies() % groupCount != 0) {
            throw new Exception(this.getErrorMsgPrefix() + "Expected equal amount of ready copies per group, but " + this.redundancy.effectiveReadyCopies() + " ready copies is specified with " + groupCount + " groups");
        }
        if (this.redundancy.effectiveReadyCopies() == 0) {
            System.err.println(this.getErrorMsgPrefix() + "Warning. No ready copies configured. At least one is recommended.");
        }
    }

    private String getErrorMsgPrefix() {
        return "In indexed content cluster '" + this.clusterName + "' using hierarchic distribution: ";
    }
}

