/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.HostSystem;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import java.util.Map;
import java.util.Optional;

public class NodesSpecification {
    private final boolean dedicated;
    private final int count;
    private final int groups;
    private Version version;
    private final boolean required;
    private final boolean canFail;
    private final boolean exclusive;
    private final Optional<String> flavor;
    private final Optional<String> dockerImage;

    private NodesSpecification(boolean dedicated, int count, int groups, Version version, boolean required, boolean canFail, boolean exclusive, Optional<String> flavor, Optional<String> dockerImage) {
        this.dedicated = dedicated;
        this.count = count;
        this.groups = groups;
        this.version = version;
        this.required = required;
        this.canFail = canFail;
        this.exclusive = exclusive;
        this.flavor = flavor;
        this.dockerImage = dockerImage;
    }

    private NodesSpecification(boolean dedicated, boolean canFail, Version version, ModelElement nodesElement) {
        this(dedicated, nodesElement.requiredIntegerAttribute("count"), nodesElement.getIntegerAttribute("groups", 1), version, nodesElement.getBooleanAttribute("required", false), canFail, nodesElement.getBooleanAttribute("exclusive", false), Optional.ofNullable(nodesElement.getStringAttribute("flavor")), Optional.ofNullable(nodesElement.getStringAttribute("docker-image")));
    }

    public static NodesSpecification from(ModelElement nodesElement, ConfigModelContext context) {
        return new NodesSpecification(true, !context.getDeployState().getProperties().isBootstrap(), context.getDeployState().getWantedNodeVespaVersion(), nodesElement);
    }

    public static Optional<NodesSpecification> fromParent(ModelElement parentElement, ConfigModelContext context) {
        if (parentElement == null) {
            return Optional.empty();
        }
        ModelElement nodesElement = parentElement.getChild("nodes");
        if (nodesElement == null) {
            return Optional.empty();
        }
        return Optional.of(NodesSpecification.from(nodesElement, context));
    }

    public static Optional<NodesSpecification> optionalDedicatedFromParent(ModelElement parentElement, ConfigModelContext context) {
        if (parentElement == null) {
            return Optional.empty();
        }
        ModelElement nodesElement = parentElement.getChild("nodes");
        if (nodesElement == null) {
            return Optional.empty();
        }
        return Optional.of(new NodesSpecification(nodesElement.getBooleanAttribute("dedicated", false), !context.getDeployState().getProperties().isBootstrap(), context.getDeployState().getWantedNodeVespaVersion(), nodesElement));
    }

    public static NodesSpecification nonDedicated(int count, ConfigModelContext context) {
        return new NodesSpecification(false, count, 1, context.getDeployState().getWantedNodeVespaVersion(), false, !context.getDeployState().getProperties().isBootstrap(), false, Optional.empty(), Optional.empty());
    }

    public boolean isDedicated() {
        return this.dedicated;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int count() {
        return this.count;
    }

    public int groups() {
        return this.groups;
    }

    public Map<HostResource, ClusterMembership> provision(HostSystem hostSystem, ClusterSpec.Type clusterType, ClusterSpec.Id clusterId, DeployLogger logger) {
        ClusterSpec cluster = ClusterSpec.request((ClusterSpec.Type)clusterType, (ClusterSpec.Id)clusterId, (Version)this.version, (boolean)this.exclusive);
        return hostSystem.allocateHosts(cluster, Capacity.fromNodeCount((int)this.count, this.flavor, (boolean)this.required, (boolean)this.canFail), this.groups, logger);
    }

    public String toString() {
        return "specification of " + this.count + (this.dedicated ? " dedicated " : " ") + "nodes" + (this.flavor.isPresent() ? " of flavor " + this.flavor.get() : "") + (this.groups > 1 ? " in " + this.groups + " groups" : "");
    }
}

