/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change.search;

import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.document.ArrayDataType;
import com.yahoo.document.DataType;
import com.yahoo.document.Field;
import com.yahoo.document.MapDataType;
import com.yahoo.document.StructDataType;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ComplexAttributeFieldUtils;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.VespaRefeedAction;
import com.yahoo.vespa.model.application.validation.change.search.ChangeMessageBuilder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;

public class StructFieldAttributeChangeValidator {
    private final NewDocumentType currentDocType;
    private final AttributeFields currentAttributes;
    private final NewDocumentType nextDocType;
    private final AttributeFields nextAttributes;

    public StructFieldAttributeChangeValidator(NewDocumentType currentDocType, AttributeFields currentAttributes, NewDocumentType nextDocType, AttributeFields nextAttributes) {
        this.currentDocType = currentDocType;
        this.currentAttributes = currentAttributes;
        this.nextDocType = nextDocType;
        this.nextAttributes = nextAttributes;
    }

    public List<VespaConfigChangeAction> validate(ValidationOverrides overrides, Instant now) {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        for (Field currentField : this.currentDocType.getAllFields()) {
            Field nextField = this.nextDocType.getField(currentField.getName());
            if (nextField == null) continue;
            result.addAll(this.validateAddAttributeAspect(new Context(currentField, this.currentAttributes), new Context(nextField, this.nextAttributes), overrides, now));
        }
        return result;
    }

    private List<VespaConfigChangeAction> validateAddAttributeAspect(Context current, Context next, ValidationOverrides overrides, Instant now) {
        return next.structFieldAttributes.stream().filter(nextAttr -> current.hasFieldFor((Attribute)nextAttr) && !current.hasStructFieldAttribute((Attribute)nextAttr)).map(nextAttr -> VespaRefeedAction.of("field-type-change", overrides, new ChangeMessageBuilder(nextAttr.getName()).addChange("add attribute aspect").build(), now)).collect(Collectors.toList());
    }

    private static class Context {
        public Field field;
        public Collection<Attribute> structFieldAttributes;

        public Context(Field field, AttributeFields attributes) {
            this.field = field;
            this.structFieldAttributes = attributes.structFieldAttributes(field.getName());
        }

        public DataType dataType() {
            return this.field.getDataType();
        }

        public boolean hasStructFieldAttribute(Attribute structFieldAttribute) {
            return this.structFieldAttributes.stream().anyMatch(attr -> attr.getName().equals(structFieldAttribute.getName()));
        }

        public boolean hasFieldFor(Attribute structFieldAttribute) {
            String subFieldName;
            StringTokenizer fieldNames = new StringTokenizer(structFieldAttribute.getName(), ".");
            if (!fieldNames.nextToken().equals(this.field.getName())) {
                return false;
            }
            if (ComplexAttributeFieldUtils.isArrayOfSimpleStruct(this.dataType())) {
                StructDataType nestedType = (StructDataType)((ArrayDataType)this.dataType()).getNestedType();
                if (Context.hasLastFieldInStructType(fieldNames, nestedType)) {
                    return true;
                }
            } else if (ComplexAttributeFieldUtils.isMapOfSimpleStruct(this.dataType())) {
                MapDataType mapType = (MapDataType)this.dataType();
                StructDataType valueType = (StructDataType)mapType.getValueType();
                String subFieldName2 = fieldNames.nextToken();
                if (subFieldName2.equals("key") && !fieldNames.hasMoreTokens()) {
                    return true;
                }
                if (subFieldName2.equals("value") && Context.hasLastFieldInStructType(fieldNames, valueType)) {
                    return true;
                }
            } else if (ComplexAttributeFieldUtils.isMapOfPrimitiveType(this.dataType()) && ((subFieldName = fieldNames.nextToken()).equals("key") || subFieldName.equals("value")) && !fieldNames.hasMoreTokens()) {
                return true;
            }
            return false;
        }

        private static boolean hasLastFieldInStructType(StringTokenizer fieldNames, StructDataType structType) {
            return structType.getField(fieldNames.nextToken()) != null && !fieldNames.hasMoreTokens();
        }
    }
}

