/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.MapDataType;
import com.yahoo.document.PrimitiveDataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class DisallowComplexMapAndWsetKeyTypes
extends Processor {
    public DisallowComplexMapAndWsetKeyTypes(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate) {
        if (!validate) {
            return;
        }
        for (SDField field : this.search.allConcreteFields()) {
            if (field.getDataType() instanceof WeightedSetDataType) {
                DataType nestedType = ((WeightedSetDataType)field.getDataType()).getNestedType();
                if (nestedType instanceof PrimitiveDataType) continue;
                this.fail(this.search, field, "Weighted set must have a primitive key type.");
                continue;
            }
            if (!(field.getDataType() instanceof MapDataType) || ((MapDataType)field.getDataType()).getKeyType() instanceof PrimitiveDataType) continue;
            this.fail(this.search, field, "Map key type must be a primitive type");
        }
    }
}

