/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.DataType;
import com.yahoo.document.WeightedSetDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Matching;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class TagType
extends Processor {
    public TagType(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate) {
        for (SDField field : this.search.allConcreteFields()) {
            if (!(field.getDataType() instanceof WeightedSetDataType) || !((WeightedSetDataType)field.getDataType()).isTag()) continue;
            this.implementTagType(field);
        }
    }

    private void implementTagType(SDField field) {
        field.setDataType((DataType)DataType.getWeightedSet((DataType)DataType.STRING, (boolean)true, (boolean)true));
        if (!field.doesIndexing() && !field.doesAttributing()) {
            return;
        }
        Matching m = field.getMatching();
        if (!m.isTypeUserSet()) {
            m.setType(Matching.Type.WORD);
        }
        if (field.getRankType() == null || field.getRankType() == RankType.DEFAULT) {
            field.setRankType(RankType.TAGS);
        }
    }
}

