/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.SDDocumentType;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.HashSet;
import java.util.Set;

public class ReservedDocumentNames
extends Processor {
    private static final Set<String> RESERVED_NAMES = new HashSet<String>();

    public ReservedDocumentNames(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process(boolean validate) {
        if (!validate) {
            return;
        }
        String docName = this.search.getDocument().getName();
        if (RESERVED_NAMES.contains(docName)) {
            throw new IllegalArgumentException("For search '" + this.search.getName() + "': Document name '" + docName + "' is reserved.");
        }
    }

    static {
        for (SDDocumentType dataType : SDDocumentType.VESPA_DOCUMENT.getTypes()) {
            RESERVED_NAMES.add(dataType.getName());
        }
    }
}

