/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.ValidationOverrides;
import com.yahoo.config.model.api.ConfigChangeAction;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.vespa.model.VespaModel;
import com.yahoo.vespa.model.application.validation.ComponentValidator;
import com.yahoo.vespa.model.application.validation.DeploymentFileValidator;
import com.yahoo.vespa.model.application.validation.NoPrefixForIndexes;
import com.yahoo.vespa.model.application.validation.RankSetupValidator;
import com.yahoo.vespa.model.application.validation.RankingConstantsValidator;
import com.yahoo.vespa.model.application.validation.RoutingSelectorValidator;
import com.yahoo.vespa.model.application.validation.RoutingValidator;
import com.yahoo.vespa.model.application.validation.SearchDataTypeValidator;
import com.yahoo.vespa.model.application.validation.StreamingValidator;
import com.yahoo.vespa.model.application.validation.change.ChangeValidator;
import com.yahoo.vespa.model.application.validation.change.ClusterSizeReductionValidator;
import com.yahoo.vespa.model.application.validation.change.ConfigValueChangeValidator;
import com.yahoo.vespa.model.application.validation.change.ContainerRestartValidator;
import com.yahoo.vespa.model.application.validation.change.ContentClusterRemovalValidator;
import com.yahoo.vespa.model.application.validation.change.IndexedSearchClusterChangeValidator;
import com.yahoo.vespa.model.application.validation.change.IndexingModeChangeValidator;
import com.yahoo.vespa.model.application.validation.change.StartupCommandChangeValidator;
import com.yahoo.vespa.model.application.validation.change.StreamingSearchClusterChangeValidator;
import com.yahoo.vespa.model.application.validation.first.AccessControlValidator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class Validation {
    public static List<ConfigChangeAction> validate(VespaModel model, boolean force, DeployState deployState) {
        return Validation.validate(model, true, force, deployState);
    }

    public static List<ConfigChangeAction> validate(VespaModel model, boolean checkRouting, boolean force, DeployState deployState) {
        if (checkRouting) {
            new RoutingValidator().validate(model, deployState);
            new RoutingSelectorValidator().validate(model, deployState);
        }
        new ComponentValidator().validate(model, deployState);
        new SearchDataTypeValidator().validate(model, deployState);
        new StreamingValidator().validate(model, deployState);
        new RankSetupValidator(force).validate(model, deployState);
        new NoPrefixForIndexes().validate(model, deployState);
        new DeploymentFileValidator().validate(model, deployState);
        new RankingConstantsValidator().validate(model, deployState);
        Optional<Model> currentActiveModel = deployState.getPreviousModel();
        if (currentActiveModel.isPresent() && currentActiveModel.get() instanceof VespaModel) {
            return Validation.validateChanges((VespaModel)currentActiveModel.get(), model, deployState.validationOverrides(), deployState.getDeployLogger(), deployState.now());
        }
        Validation.validateFirstTimeDeployment(model, deployState);
        return new ArrayList<ConfigChangeAction>();
    }

    private static List<ConfigChangeAction> validateChanges(VespaModel currentModel, VespaModel nextModel, ValidationOverrides overrides, DeployLogger logger, Instant now) {
        ChangeValidator[] validators = new ChangeValidator[]{new IndexingModeChangeValidator(), new IndexedSearchClusterChangeValidator(), new StreamingSearchClusterChangeValidator(), new ConfigValueChangeValidator(logger), new StartupCommandChangeValidator(), new ContentClusterRemovalValidator(), new ClusterSizeReductionValidator(), new ContainerRestartValidator()};
        return Arrays.stream(validators).flatMap(v -> v.validate(currentModel, nextModel, overrides, now).stream()).collect(Collectors.toList());
    }

    private static void validateFirstTimeDeployment(VespaModel model, DeployState deployState) {
        new AccessControlValidator().validate(model, deployState);
    }
}

