/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing.multifieldresolver;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.search.query.profile.types.FieldDescription;
import com.yahoo.search.query.profile.types.FieldType;
import com.yahoo.search.query.profile.types.QueryProfileType;
import com.yahoo.search.query.profile.types.TensorFieldType;
import com.yahoo.searchdefinition.FeatureNames;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.ImportedField;
import com.yahoo.searchdefinition.document.ImportedFields;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;
import java.util.Map;
import java.util.Optional;

public class RankProfileTypeSettingsProcessor
extends Processor {
    public RankProfileTypeSettingsProcessor(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process() {
        this.processAttributeFields();
        this.processImportedFields();
        this.processQueryProfileTypes();
    }

    private void processAttributeFields() {
        for (SDField field : this.search.allConcreteFields()) {
            Attribute attribute = field.getAttributes().get(field.getName());
            if (attribute == null || !attribute.tensorType().isPresent()) continue;
            this.addAttributeTypeToRankProfiles(attribute.getName(), attribute.tensorType().get().toString());
        }
    }

    private void processImportedFields() {
        Optional<ImportedFields> importedFields = this.search.importedFields();
        if (importedFields.isPresent()) {
            importedFields.get().fields().forEach((fieldName, field) -> this.processImportedField((ImportedField)field));
        }
    }

    private void processImportedField(ImportedField field) {
        SDField targetField = field.targetField();
        Attribute attribute = targetField.getAttributes().get(targetField.getName());
        if (attribute != null && attribute.tensorType().isPresent()) {
            this.addAttributeTypeToRankProfiles(field.fieldName(), attribute.tensorType().get().toString());
        }
    }

    private void addAttributeTypeToRankProfiles(String attributeName, String attributeType) {
        for (RankProfile profile : this.rankProfileRegistry.allRankProfiles()) {
            profile.addAttributeType(attributeName, attributeType);
        }
    }

    private void processQueryProfileTypes() {
        for (QueryProfileType queryProfileType : this.queryProfiles.getRegistry().getTypeRegistry().allComponents()) {
            for (Map.Entry fieldDescEntry : queryProfileType.fields().entrySet()) {
                this.processFieldDescription((FieldDescription)fieldDescEntry.getValue());
            }
        }
    }

    private void processFieldDescription(FieldDescription fieldDescription) {
        String fieldName = fieldDescription.getName();
        FieldType fieldType = fieldDescription.getType();
        if (fieldType instanceof TensorFieldType) {
            TensorFieldType tensorFieldType = (TensorFieldType)fieldType;
            FeatureNames.argumentOf(fieldName).ifPresent(argument -> this.addQueryFeatureTypeToRankProfiles((String)argument, tensorFieldType.asTensorType().toString()));
        }
    }

    private void addQueryFeatureTypeToRankProfiles(String queryFeature, String queryFeatureType) {
        for (RankProfile profile : this.rankProfileRegistry.allRankProfiles()) {
            profile.addQueryFeatureType(queryFeature, queryFeatureType);
        }
    }
}

