/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FeatureNames {
    private static final Pattern identifierRegexp = Pattern.compile("[A-Za-z0-9_][A-Za-z0-9_-]*");

    public static String canonicalize(String feature) {
        return FeatureNames.canonicalizeIfValid(feature).orElseThrow(() -> new IllegalArgumentException("A feature name must be on the form query(name), attribute(name) or constant(name), but was '" + feature + "'"));
    }

    public static Optional<String> canonicalizeIfValid(String feature) {
        int startParenthesis = feature.indexOf(40);
        if (startParenthesis < 0) {
            return Optional.empty();
        }
        int endParenthesis = feature.lastIndexOf(41);
        String featureType = feature.substring(0, startParenthesis);
        if (!(featureType.equals("query") || featureType.equals("attribute") || featureType.equals("constant"))) {
            return Optional.empty();
        }
        if (startParenthesis < 1) {
            return Optional.of(feature);
        }
        if (endParenthesis < startParenthesis) {
            return Optional.empty();
        }
        String argumentString = feature.substring(startParenthesis + 1, endParenthesis);
        List canonicalizedArguments = Arrays.stream(argumentString.split(",")).map(FeatureNames::canonicalizeArgument).collect(Collectors.toList());
        return Optional.of(featureType + "(" + canonicalizedArguments.stream().collect(Collectors.joining(",")) + feature.substring(endParenthesis));
    }

    private static String canonicalizeArgument(String argument) {
        if (argument.startsWith("'")) {
            if (!argument.endsWith("'")) {
                throw new IllegalArgumentException("Feature arguments starting by a single quote must end by a single quote, but was \"" + argument + "\"");
            }
            argument = argument.substring(1, argument.length() - 1);
        }
        if (argument.startsWith("\"")) {
            if (!argument.endsWith("\"")) {
                throw new IllegalArgumentException("Feature arguments starting by a double quote must end by a double quote, but was '" + argument + "'");
            }
            argument = argument.substring(1, argument.length() - 1);
        }
        if (identifierRegexp.matcher(argument).matches()) {
            return argument;
        }
        return "\"" + argument + "\"";
    }

    public static String asConstantFeature(String constantName) {
        return FeatureNames.canonicalize("constant(\"" + constantName + "\")");
    }

    public static String asAttributeFeature(String attributeName) {
        return FeatureNames.canonicalize("attribute(\"" + attributeName + "\")");
    }

    public static String asQueryFeature(String propertyName) {
        return FeatureNames.canonicalize("query(\"" + propertyName + "\")");
    }

    public static Optional<String> argumentOf(String feature) {
        return FeatureNames.canonicalizeIfValid(feature).map(f -> {
            int endParenthesis;
            int startParenthesis = f.indexOf("(");
            String possiblyQuotedArgument = f.substring(startParenthesis + 1, endParenthesis = f.indexOf(")"));
            if (possiblyQuotedArgument.startsWith("\"")) {
                return possiblyQuotedArgument.substring(1, possiblyQuotedArgument.length() - 1);
            }
            return possiblyQuotedArgument;
        });
    }
}

