/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.jersey;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.config.jersey.JerseyInitConfig;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.jersey.Jersey2Servlet;
import com.yahoo.vespa.model.container.jersey.JerseyHandler;
import com.yahoo.vespa.model.container.jersey.RestApiContext;
import java.util.Optional;

public class RestApi
extends AbstractConfigProducer<AbstractConfigProducer<?>>
implements JerseyInitConfig.Producer {
    public final boolean isJersey2;
    private final String bindingPath;
    private final Component<?, ?> jerseyHandler;
    private RestApiContext restApiContext;

    public RestApi(String bindingPath, boolean isJersey2) {
        super(RestApi.idFromPath(bindingPath));
        this.bindingPath = bindingPath;
        this.isJersey2 = isJersey2;
        this.jerseyHandler = isJersey2 ? this.createJersey2Servlet(this.bindingPath) : RestApi.createJersey1Handler(this.bindingPath);
        this.addChild(this.jerseyHandler);
    }

    public static String idFromPath(String path) {
        return path.replaceAll("/", "|");
    }

    private Jersey2Servlet createJersey2Servlet(String bindingPath) {
        return new Jersey2Servlet(bindingPath);
    }

    private static JerseyHandler createJersey1Handler(String bindingPath) {
        JerseyHandler jerseyHandler = new JerseyHandler(bindingPath);
        jerseyHandler.addServerBindings(RestApi.getBindings(bindingPath));
        return jerseyHandler;
    }

    public String getBindingPath() {
        return this.bindingPath;
    }

    public void getConfig(JerseyInitConfig.Builder builder) {
        builder.jerseyMapping(this.bindingPath);
    }

    public void setRestApiContext(RestApiContext restApiContext) {
        this.restApiContext = restApiContext;
        this.addChild(restApiContext);
        this.jerseyHandler.inject(restApiContext);
    }

    public RestApiContext getContext() {
        return this.restApiContext;
    }

    public Optional<JerseyHandler> getJersey1Handler() {
        return this.isJersey2 ? Optional.empty() : Optional.of((JerseyHandler)this.jerseyHandler);
    }

    public Optional<Jersey2Servlet> getJersey2Servlet() {
        return this.isJersey2 ? Optional.of((Jersey2Servlet)this.jerseyHandler) : Optional.empty();
    }

    private static String[] getBindings(String bindingPath) {
        String bindingWithoutScheme = "://*/" + bindingPath + "/*";
        return new String[]{"http" + bindingWithoutScheme, "https" + bindingWithoutScheme};
    }

    public void prepare() {
        this.restApiContext.prepare();
    }
}

