/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.http.xml;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.ApplicationName;
import com.yahoo.log.LogLevel;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.chain.Chain;
import com.yahoo.vespa.model.container.http.AccessControl;
import com.yahoo.vespa.model.container.http.FilterChains;
import com.yahoo.vespa.model.container.http.Http;
import com.yahoo.vespa.model.container.http.JettyHttpServer;
import com.yahoo.vespa.model.container.http.xml.FilterChainsBuilder;
import com.yahoo.vespa.model.container.http.xml.JettyHttpServerBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Element;

public class HttpBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<Http> {
    @Override
    protected Http doBuild(AbstractConfigProducer ancestor, Element spec) {
        FilterChains filterChains;
        List<Http.Binding> bindings = new ArrayList<Http.Binding>();
        AccessControl accessControl = null;
        Element filteringElem = XML.getChild((Element)spec, (String)"filtering");
        if (filteringElem != null) {
            filterChains = (FilterChains)new FilterChainsBuilder().build(ancestor, filteringElem);
            bindings = this.readFilterBindings(filteringElem);
            Element accessControlElem = XML.getChild((Element)filteringElem, (String)"access-control");
            if (accessControlElem != null) {
                accessControl = this.buildAccessControl(ancestor, accessControlElem);
                bindings.addAll(accessControl.getBindings());
                filterChains.add(new Chain(FilterChains.emptyChainSpec(AccessControl.ACCESS_CONTROL_CHAIN_ID)));
            }
        } else {
            filterChains = new FilterChainsBuilder().newChainsInstance(ancestor);
        }
        Http http = new Http(bindings, accessControl);
        http.setFilterChains(filterChains);
        this.buildHttpServers(ancestor, http, spec);
        return http;
    }

    private AccessControl buildAccessControl(AbstractConfigProducer ancestor, Element accessControlElem) {
        String application = XmlHelper.getOptionalChildValue(accessControlElem, "application").orElse(HttpBuilder.getDeployedApplicationId(ancestor).value());
        AccessControl.Builder builder = new AccessControl.Builder(accessControlElem.getAttribute("domain"), application);
        HttpBuilder.getContainerCluster(ancestor).ifPresent(cluster -> {
            builder.setHandlers(cluster.getHandlers());
            builder.setServlets(cluster.getAllServlets());
        });
        XmlHelper.getOptionalAttribute(accessControlElem, "read").ifPresent(readAttr -> builder.readEnabled(Boolean.valueOf(readAttr)));
        XmlHelper.getOptionalAttribute(accessControlElem, "write").ifPresent(writeAttr -> builder.writeEnabled(Boolean.valueOf(writeAttr)));
        Element excludeElem = XML.getChild((Element)accessControlElem, (String)"exclude");
        if (excludeElem != null) {
            XML.getChildren((Element)excludeElem, (String)"binding").stream().map(XML::getValue).forEach(builder::excludeBinding);
        }
        XmlHelper.getOptionalChildValue(accessControlElem, "vespa-domain").ifPresent(builder::vespaDomain);
        return builder.build();
    }

    private static ApplicationName getDeployedApplicationId(AbstractConfigProducer ancestor) {
        return HttpBuilder.getContainerCluster(ancestor).map(cluster -> cluster.getRoot().getDeployState().getProperties().applicationId().application()).orElse(ApplicationId.defaultId().application());
    }

    private static Optional<ContainerCluster> getContainerCluster(AbstractConfigProducer configProducer) {
        AbstractConfigProducer currentProducer = configProducer;
        while (currentProducer.getClass() != ContainerCluster.class) {
            if ((currentProducer = currentProducer.getParent()) != null) continue;
            return Optional.empty();
        }
        return Optional.of((ContainerCluster)currentProducer);
    }

    private List<Http.Binding> readFilterBindings(Element filteringSpec) {
        ArrayList<Http.Binding> result = new ArrayList<Http.Binding>();
        for (Element child : XML.getChildren((Element)filteringSpec)) {
            String tagName = child.getTagName();
            if (!tagName.equals("request-chain") && !tagName.equals("response-chain")) continue;
            ComponentSpecification chainId = XmlHelper.getIdRef(child);
            for (Element bindingSpec : XML.getChildren((Element)child, (String)"binding")) {
                String binding = XML.getValue((Element)bindingSpec);
                result.add(new Http.Binding(chainId, binding));
            }
        }
        return result;
    }

    private void buildHttpServers(AbstractConfigProducer ancestor, Http http, Element spec) {
        http.setHttpServer((JettyHttpServer)new JettyHttpServerBuilder().build(ancestor, spec));
    }

    static int readPort(Element spec, DeployState deployState) {
        String portString = spec.getAttribute("port");
        int port = Integer.parseInt(portString);
        if (port < 0) {
            throw new IllegalArgumentException(String.format("Invalid port %d.", port));
        }
        int legalPortInHostedVespa = Container.BASEPORT;
        if (deployState.isHosted() && port != legalPortInHostedVespa) {
            deployState.getDeployLogger().log(LogLevel.WARNING, String.format("Trying to set port to %d for http server with id %s. You cannot set port to anything else than %s", port, spec.getAttribute("id"), legalPortInHostedVespa));
        }
        return port;
    }
}

