/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.documentmodel;

import com.yahoo.document.Field;
import com.yahoo.vespa.documentmodel.FieldView;
import com.yahoo.vespa.documentmodel.SummaryField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DocumentSummary
extends FieldView {
    public DocumentSummary(String name) {
        super(name);
    }

    public void add(SummaryField summaryField) {
        summaryField.addDestination(this.getName());
        super.add(summaryField);
    }

    public SummaryField getSummaryField(String name) {
        return (SummaryField)this.get(name);
    }

    public Collection<SummaryField> getSummaryFields() {
        ArrayList<SummaryField> fields = new ArrayList<SummaryField>(this.getFields().size());
        for (Field f : this.getFields()) {
            fields.add((SummaryField)f);
        }
        return fields;
    }

    public void purgeImplicits() {
        ArrayList<SummaryField> falseImplicits = new ArrayList<SummaryField>();
        for (SummaryField summaryField : this.getSummaryFields()) {
            if (summaryField.isImplicit()) continue;
            Iterator<SummaryField.Source> j = summaryField.sourceIterator();
            while (j.hasNext()) {
                SummaryField sourceField;
                String sourceName = j.next().getName();
                if (sourceName.equals(summaryField.getName()) || (sourceField = this.getSummaryField(sourceName)) == null || !sourceField.isImplicit()) continue;
                falseImplicits.add(sourceField);
            }
        }
        for (SummaryField field : falseImplicits) {
            this.remove(field.getName());
        }
    }

    public String toString() {
        return "document summary '" + this.getName() + "'";
    }
}

