/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.expressiontransforms;

import com.yahoo.searchdefinition.expressiontransforms.RankProfileTransformContext;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.NameNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConstantTensorTransformer
extends ExpressionTransformer<RankProfileTransformContext> {
    public static final String CONSTANT = "constant";

    public ExpressionNode transform(ExpressionNode node, RankProfileTransformContext context) {
        if (node instanceof ReferenceNode) {
            return this.transformFeature((ReferenceNode)node, context);
        }
        if (node instanceof CompositeNode) {
            return this.transformChildren((CompositeNode)node, context);
        }
        return node;
    }

    private ExpressionNode transformFeature(ReferenceNode node, RankProfileTransformContext context) {
        if (!node.getArguments().isEmpty()) {
            return this.transformArguments(node, context);
        }
        return this.transformConstantReference(node, context);
    }

    private ExpressionNode transformArguments(ReferenceNode node, RankProfileTransformContext context) {
        List arguments = node.getArguments().expressions();
        ArrayList<ExpressionNode> transformedArguments = new ArrayList<ExpressionNode>(arguments.size());
        for (ExpressionNode argument : arguments) {
            transformedArguments.add(this.transform(argument, context));
        }
        return node.setArguments(transformedArguments);
    }

    private ExpressionNode transformConstantReference(ReferenceNode node, RankProfileTransformContext context) {
        Value value = (Value)context.constants().get(node.getName());
        if (value == null || value.type().rank() == 0) {
            return node;
        }
        TensorValue tensorValue = (TensorValue)value;
        String featureName = "constant(" + node.getName() + ")";
        String tensorType = tensorValue.asTensor().type().toString();
        context.rankPropertiesOutput().put(featureName + ".value", tensorValue.toString());
        context.rankPropertiesOutput().put(featureName + ".type", tensorType);
        return new ReferenceNode(CONSTANT, Arrays.asList(new NameNode(node.getName())), null);
    }
}

