/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.defaults.Defaults;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.admin.ZooKeepersConfigProvider;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Configserver
extends AbstractService {
    private static final long serialVersionUID = 1L;
    private static final int defaultPort = 19070;
    private static final Logger log = Logger.getLogger(Configserver.class.getName());

    public Configserver(AbstractConfigProducer parent, String name) {
        super(parent, name);
        this.portsMeta.on(0).tag("rpc").tag("config");
        this.portsMeta.on(1).tag("http").tag("config").tag("state");
        this.setProp("clustertype", "admin");
        this.setProp("clustername", "admin");
    }

    @Override
    public int getWantedPort() {
        try {
            Process process = new ProcessBuilder(Defaults.getDefaults().underVespaHome("bin/vespa-print-default"), "configserver_rpc_port").start();
            InputStream in = process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            return Integer.parseInt(reader.readLine().trim());
        }
        catch (Exception exception) {
            log.log((Level)LogLevel.DEBUG, "Error reading port from script, using 19070");
            return 19070;
        }
    }

    @Override
    public boolean requiresWantedPort() {
        return this.getId() < 2;
    }

    @Override
    public int getPortCount() {
        return 2;
    }

    @Override
    public boolean getAutostartFlag() {
        return false;
    }

    @Override
    public boolean getAutorestartFlag() {
        return false;
    }

    private int getConfigServerRpcPort() {
        return this.getRelativePort(0);
    }

    private int getConfigServerHttpPort() {
        return this.getRelativePort(1);
    }

    public ConfigServerSpec getConfigServerSpec() {
        return new Spec(this.getHostName(), this.getConfigServerRpcPort(), this.getConfigServerHttpPort(), ZooKeepersConfigProvider.zkPort);
    }

    @Override
    public int getHealthPort() {
        return this.getRelativePort(1);
    }

    public static class Spec
    implements ConfigServerSpec {
        private final String hostName;
        private final int configServerPort;
        private final int httpPort;
        private final int zooKeeperPort;

        public String getHostName() {
            return this.hostName;
        }

        public int getConfigServerPort() {
            return this.configServerPort;
        }

        public int getHttpPort() {
            return this.httpPort;
        }

        public int getZooKeeperPort() {
            return this.zooKeeperPort;
        }

        public boolean equals(Object o) {
            if (o instanceof ConfigServerSpec) {
                ConfigServerSpec other = (ConfigServerSpec)o;
                return this.hostName.equals(other.getHostName()) && this.configServerPort == other.getConfigServerPort() && this.httpPort == other.getHttpPort() && this.zooKeeperPort == other.getZooKeeperPort();
            }
            return false;
        }

        public int hashCode() {
            return this.hostName.hashCode();
        }

        public Spec(String hostName, int configServerPort, int httpPort, int zooKeeperPort) {
            this.hostName = hostName;
            this.configServerPort = configServerPort;
            this.httpPort = httpPort;
            this.zooKeeperPort = zooKeeperPort;
        }
    }
}

