/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.Derived;
import com.yahoo.searchdefinition.derived.RawRankProfile;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import java.util.LinkedHashMap;
import java.util.Map;

public class RankProfileList
extends Derived
implements RankProfilesConfig.Producer {
    private Map<String, RawRankProfile> rankProfiles = new LinkedHashMap<String, RawRankProfile>();

    public RankProfileList(Search search, AttributeFields attributeFields, RankProfileRegistry rankProfileRegistry) {
        this.setName(search.getName());
        this.deriveRankProfiles(rankProfileRegistry, search, attributeFields);
    }

    private void deriveRankProfiles(RankProfileRegistry rankProfileRegistry, Search search, AttributeFields attributeFields) {
        RawRankProfile defaultProfile = new RawRankProfile(rankProfileRegistry.getRankProfile(search, "default"), attributeFields);
        this.rankProfiles.put(defaultProfile.getName(), defaultProfile);
        for (RankProfile rank : rankProfileRegistry.localRankProfiles(search)) {
            if ("default".equals(rank.getName())) continue;
            RawRankProfile rawRank = new RawRankProfile(rank, attributeFields);
            this.rankProfiles.put(rawRank.getName(), rawRank);
        }
    }

    public Map<String, RawRankProfile> getRankProfiles() {
        return this.rankProfiles;
    }

    public RawRankProfile getRankProfile(String name) {
        return this.rankProfiles.get(name);
    }

    @Override
    public String getDerivedName() {
        return "rank-profiles";
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        for (RawRankProfile rank : this.rankProfiles.values()) {
            rank.getConfig(builder);
        }
    }
}

