/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.builder.xml;

import com.yahoo.component.AbstractComponent;
import com.yahoo.config.model.ConfigModel;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.ConfigModelInstanceFactory;
import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.api.ConfigModelPlugin;
import com.yahoo.config.model.builder.xml.ConfigModelId;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.w3c.dom.Element;

public abstract class ConfigModelBuilder<MODEL extends ConfigModel>
extends AbstractComponent
implements ConfigModelPlugin {
    private Class<MODEL> configModelClass;

    public ConfigModelBuilder(Class<MODEL> configModelClass) {
        this.configModelClass = configModelClass;
    }

    public abstract List<ConfigModelId> handlesElements();

    public abstract void doBuild(MODEL var1, Element var2, ConfigModelContext var3);

    public final MODEL build(DeployState deployState, ConfigModelRepo configModelRepo, AbstractConfigProducer parent, Element spec) {
        ConfigModelContext context = ConfigModelContext.create(deployState, configModelRepo, parent, ConfigModelBuilder.getIdString(spec));
        return this.build(new DefaultModelInstanceFactory(), spec, context);
    }

    public MODEL build(ConfigModelInstanceFactory<MODEL> factory, Element spec, ConfigModelContext context) {
        MODEL model = factory.createModel(context);
        this.doBuild(model, spec, context);
        return model;
    }

    public Class<MODEL> getModelClass() {
        return this.configModelClass;
    }

    private static String getIdString(Element spec) {
        String idString = XmlHelper.getIdString(spec);
        if (idString == null || idString.isEmpty()) {
            idString = spec.getTagName();
        }
        return idString;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConfigModelBuilder)) {
            return false;
        }
        ConfigModelBuilder otherBuilder = (ConfigModelBuilder)((Object)other);
        List<ConfigModelId> thisIds = this.handlesElements();
        List<ConfigModelId> otherIds = otherBuilder.handlesElements();
        if (thisIds.size() != otherIds.size()) {
            return false;
        }
        for (int i = 0; i < thisIds.size(); ++i) {
            if (thisIds.get(i).equals(otherIds.get(i))) continue;
            return false;
        }
        return true;
    }

    private class DefaultModelInstanceFactory
    implements ConfigModelInstanceFactory<MODEL> {
        private DefaultModelInstanceFactory() {
        }

        @Override
        public MODEL createModel(ConfigModelContext context) {
            try {
                Constructor constructor = ConfigModelBuilder.this.configModelClass.getConstructor(ConfigModelContext.class);
                return (ConfigModel)constructor.newInstance(context);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Error constructing model '" + ConfigModelBuilder.this.configModelClass.getName() + "'", e);
            }
        }
    }
}

