/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.filedistribution;

import com.yahoo.cloud.config.filedistribution.FiledistributorConfig;
import com.yahoo.cloud.config.filedistribution.FiledistributorrpcConfig;
import com.yahoo.cloud.config.filedistribution.FilereferencesConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.admin.FileDistributionOptions;
import com.yahoo.vespa.model.filedistribution.FileDistributor;
import java.util.Collection;

public class FileDistributionConfigProvider {
    private final FileDistributor fileDistributor;
    private final FileDistributionOptions fileDistributionOptions;
    private final boolean sendAllFiles;
    private final Host host;

    public FileDistributionConfigProvider(FileDistributor fileDistributor, FileDistributionOptions fileDistributionOptions, boolean sendAllFiles, Host host) {
        this.fileDistributor = fileDistributor;
        this.fileDistributionOptions = fileDistributionOptions;
        this.sendAllFiles = sendAllFiles;
        this.host = host;
    }

    public void getConfig(FiledistributorConfig.Builder builder) {
        this.fileDistributionOptions.getConfig(builder);
        builder.torrentport(19093);
        builder.stateport(19094);
        builder.hostname(this.host.getHostName());
        builder.filedbpath(FileDistribution.getDefaultFileDBPath().toString());
    }

    public void getConfig(FiledistributorrpcConfig.Builder builder) {
        int port = this.fileDistributionOptions.disableFiledistributor() ? 19090 : 19092;
        builder.connectionspec("tcp/" + this.host.getHostName() + ":" + port);
    }

    public void getConfig(FilereferencesConfig.Builder builder) {
        for (FileReference reference : this.getFileReferences()) {
            builder.filereferences(reference.value());
        }
    }

    private Collection<FileReference> getFileReferences() {
        if (this.sendAllFiles) {
            return this.fileDistributor.allFilesToSend();
        }
        return this.fileDistributor.filesToSendToHost(this.host);
    }
}

