/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.xml;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.config.model.builder.xml.XmlHelper;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.VespaDomBuilder;
import com.yahoo.vespa.model.container.Container;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class ContainerServiceBuilder
extends VespaDomBuilder.DomConfigProducerBuilder<Container> {
    private final String id;
    private final int index;

    public ContainerServiceBuilder(String id, int index) {
        this.id = id;
        this.index = index;
    }

    @Override
    protected Container doBuild(AbstractConfigProducer parent, Element nodeElem) {
        return new Container(parent, this.id, this.readServerPortOverrides(nodeElem), this.index);
    }

    private List<Container.PortOverride> readServerPortOverrides(Element spec) {
        ArrayList<Container.PortOverride> portOverrides = new ArrayList<Container.PortOverride>();
        for (Element serverPort : XML.getChildren((Element)spec, (String)"server-port")) {
            ComponentSpecification serverId = XmlHelper.getIdRef(serverPort);
            int port = Integer.parseInt(serverPort.getAttribute("port"));
            portOverrides.add(new Container.PortOverride(serverId, port));
        }
        return portOverrides;
    }
}

