/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.container.jersey;

import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.container.di.config.JerseyBundlesConfig;
import com.yahoo.container.di.config.JerseyInjectionConfig;
import com.yahoo.osgi.provider.model.ComponentModel;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.component.Component;
import com.yahoo.vespa.model.container.component.SimpleComponent;
import com.yahoo.vespa.model.container.jersey.RestApi;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Logger;

public class RestApiContext
extends SimpleComponent
implements JerseyBundlesConfig.Producer,
JerseyInjectionConfig.Producer {
    private static final Logger log = Logger.getLogger(RestApi.class.getName());
    public static final String CONTAINER_CLASS = "com.yahoo.container.di.config.RestApiContext";
    private final List<BundleInfo> bundles = new ArrayList<BundleInfo>();
    private final Map<String, String> injectComponentForClass = new LinkedHashMap<String, String>();
    private final String bindingPath;
    @Nullable
    private ContainerCluster containerCluster;
    private Predicate<Component> isCycleGeneratingComponent = component -> {
        switch (component.getClassId().getName()) {
            case "com.yahoo.container.di.config.RestApiContext": 
            case "com.yahoo.container.jdisc.jersey.JerseyHandler": 
            case "com.yahoo.container.servlet.jersey.JerseyServletProvider": 
            case "com.yahoo.jdisc.http.server.jetty.JettyHttpServer": 
            case "com.yahoo.container.handler.observability.ApplicationStatusHandler": {
                return true;
            }
        }
        return false;
    };

    public RestApiContext(AbstractConfigProducer<?> ancestor, String bindingPath) {
        super(RestApiContext.componentModel(bindingPath));
        this.bindingPath = bindingPath;
        if (ancestor instanceof ContainerCluster) {
            this.containerCluster = (ContainerCluster)ancestor;
        }
    }

    private static ComponentModel componentModel(String bindingPath) {
        return new ComponentModel(BundleInstantiationSpecification.getFromStrings((String)("com.yahoo.container.di.config.RestApiContext-" + RestApi.idFromPath(bindingPath)), (String)CONTAINER_CLASS, null));
    }

    public void getConfig(JerseyBundlesConfig.Builder builder) {
        builder.bundles(this.createBundlesConfig(this.bundles));
    }

    private List<JerseyBundlesConfig.Bundles.Builder> createBundlesConfig(List<BundleInfo> bundles) {
        ArrayList<JerseyBundlesConfig.Bundles.Builder> builders = new ArrayList<JerseyBundlesConfig.Bundles.Builder>();
        for (BundleInfo b : bundles) {
            builders.add(new JerseyBundlesConfig.Bundles.Builder().spec(b.spec).packages(b.getPackagesToScan()));
        }
        return builders;
    }

    public void addBundles(Collection<BundleInfo> newBundles) {
        this.bundles.addAll(newBundles);
    }

    public void getConfig(JerseyInjectionConfig.Builder builder) {
        for (Map.Entry<String, String> i : this.injectComponentForClass.entrySet()) {
            builder.inject(new JerseyInjectionConfig.Inject.Builder().forClass(i.getKey()).instance(i.getValue()));
        }
    }

    public void addInjections(Map<String, String> injections) {
        this.injectComponentForClass.putAll(injections);
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        if (this.bundles.isEmpty()) {
            log.warning("No bundles in rest-api '" + this.bindingPath + "' - components will only be loaded from classpath.");
        }
    }

    public void prepare() {
        if (this.containerCluster == null) {
            return;
        }
        this.containerCluster.getAllComponents().stream().filter(this.isCycleGeneratingComponent.negate()).forEach(this::inject);
    }

    public static class BundleInfo {
        public final String spec;
        private final List<String> packagesToScan = new ArrayList<String>();

        public BundleInfo(String spec) {
            this.spec = spec;
        }

        public List<String> getPackagesToScan() {
            return this.packagesToScan;
        }

        public void addPackageToScan(String pkg) {
            this.packagesToScan.add(pkg);
        }
    }
}

