/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.clients;

import com.yahoo.config.model.ConfigModel;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.documentapi.messagebus.loadtypes.LoadType;
import com.yahoo.documentapi.messagebus.loadtypes.LoadTypeSet;
import com.yahoo.vespa.config.content.LoadTypeConfig;
import com.yahoo.vespa.model.clients.VespaSpoolerService;
import java.util.LinkedList;
import java.util.List;

public class Clients
extends ConfigModel {
    private static final long serialVersionUID = 1L;
    private List<VespaSpoolerService> vespaSpoolers = new LinkedList<VespaSpoolerService>();
    private LoadTypeSet loadTypes = new LoadTypeSet();
    private final AbstractConfigProducer parent;

    public Clients(ConfigModelContext modelContext) {
        super(modelContext);
        this.parent = modelContext.getParentProducer();
    }

    public AbstractConfigProducer getConfigProducer() {
        return this.parent;
    }

    public List<VespaSpoolerService> getVespaSpoolers() {
        return this.vespaSpoolers;
    }

    public LoadTypeSet getLoadTypes() {
        return this.loadTypes;
    }

    public void getConfig(LoadTypeConfig.Builder builder) {
        for (LoadType t : this.loadTypes.getNameMap().values()) {
            if (t == LoadType.DEFAULT) continue;
            builder.type(this.getLoadTypeConfig(t));
        }
    }

    private LoadTypeConfig.Type.Builder getLoadTypeConfig(LoadType loadType) {
        LoadTypeConfig.Type.Builder builder = new LoadTypeConfig.Type.Builder();
        builder.name(loadType.getName());
        builder.id(loadType.getId());
        builder.priority(loadType.getPriority().toString());
        return builder;
    }
}

