/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.derived;

import com.google.common.collect.ImmutableList;
import com.yahoo.collections.Pair;
import com.yahoo.compress.Compressor;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.derived.AttributeFields;
import com.yahoo.searchdefinition.derived.FieldRankSettings;
import com.yahoo.searchdefinition.derived.NativeRankTypeDefinition;
import com.yahoo.searchdefinition.derived.NativeRankTypeDefinitionSet;
import com.yahoo.searchdefinition.derived.NativeTable;
import com.yahoo.searchdefinition.document.RankType;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.vespa.config.search.RankProfilesConfig;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RawRankProfile
implements RankProfilesConfig.Producer {
    private static final Compressor compressor = new Compressor();
    private final String keyEndMarker = "\r=";
    private final String valueEndMarker = "\r\n";
    public static final String summaryFeatureFefPropertyPrefix = "vespa.summary.feature";
    public static final String rankFeatureFefPropertyPrefix = "vespa.dump.feature";
    private final String name;
    private final Compressor.Compression compressedProperties;

    public RawRankProfile(RankProfile rankProfile, AttributeFields attributeFields) {
        this.name = rankProfile.getName();
        this.compressedProperties = this.compress(this.removePartFromKeys(new Deriver(rankProfile, attributeFields).derive()));
    }

    private List<Pair<String, String>> removePartFromKeys(Map<String, String> map) {
        ImmutableList.Builder replaced = new ImmutableList.Builder();
        for (Map.Entry<String, String> e : map.entrySet()) {
            String key = e.getKey().replaceFirst(".part\\d+$", "");
            String val = e.getValue();
            replaced.add((Object)new Pair((Object)key, (Object)val));
        }
        return replaced.build();
    }

    private Compressor.Compression compress(List<Pair<String, String>> properties) {
        StringBuilder b = new StringBuilder();
        for (Pair<String, String> property : properties) {
            b.append((String)property.getFirst()).append("\r=").append((String)property.getSecond()).append("\r\n");
        }
        return compressor.compress(b.toString().getBytes(Charset.forName("utf8")));
    }

    private List<Pair<String, String>> decompress(Compressor.Compression compression) {
        String propertiesString = new String(compressor.decompress(compression), Charset.forName("utf8"));
        if (propertiesString.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder properties = new ImmutableList.Builder();
        for (String propertyString : propertiesString.split("\r\n")) {
            String[] property = propertyString.split("\r=");
            properties.add((Object)new Pair((Object)property[0], (Object)property[1]));
        }
        return properties.build();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return " rank profile " + this.name;
    }

    public void getConfig(RankProfilesConfig.Builder builder) {
        RankProfilesConfig.Rankprofile.Builder b = new RankProfilesConfig.Rankprofile.Builder().name(this.getName());
        this.getRankProperties(b);
        builder.rankprofile(b);
    }

    private void getRankProperties(RankProfilesConfig.Rankprofile.Builder b) {
        RankProfilesConfig.Rankprofile.Fef.Builder fefB = new RankProfilesConfig.Rankprofile.Fef.Builder();
        for (Pair<String, String> p : this.decompress(this.compressedProperties)) {
            fefB.property(new RankProfilesConfig.Rankprofile.Fef.Property.Builder().name((String)p.getFirst()).value((String)p.getSecond()));
        }
        b.fef(fefB);
    }

    public List<Pair<String, String>> configProperties() {
        return this.decompress(this.compressedProperties);
    }

    private static class Deriver {
        private Map<String, FieldRankSettings> fieldRankSettings = new LinkedHashMap<String, FieldRankSettings>();
        private RankingExpression firstPhaseRanking = null;
        private RankingExpression secondPhaseRanking = null;
        private Set<ReferenceNode> summaryFeatures = new LinkedHashSet<ReferenceNode>();
        private Set<ReferenceNode> rankFeatures = new LinkedHashSet<ReferenceNode>();
        private List<RankProfile.RankProperty> rankProperties = new ArrayList<RankProfile.RankProperty>();
        private List<RankProfile.RankProperty> boostAndWeightRankProperties = new ArrayList<RankProfile.RankProperty>();
        private boolean ignoreDefaultRankFeatures = false;
        private RankProfile.MatchPhaseSettings matchPhaseSettings = null;
        private int rerankCount = -1;
        private int keepRankCount = -1;
        private int numThreadsPerSearch = -1;
        private int minHitsPerThread = -1;
        private int numSearchPartitions = -1;
        private double termwiseLimit = 1.0;
        private double rankScoreDropLimit = -1.7976931348623157E308;
        private NativeRankTypeDefinitionSet nativeRankTypeDefinitions = new NativeRankTypeDefinitionSet("default");
        private RankProfile rankProfile;
        private Set<String> filterFields = new LinkedHashSet<String>();

        public Deriver(RankProfile rankProfile, AttributeFields attributeFields) {
            this.rankProfile = rankProfile.compile();
            this.deriveRankingFeatures(this.rankProfile);
            this.deriveRankTypeSetting(this.rankProfile, attributeFields);
            this.deriveFilterFields(this.rankProfile);
            this.deriveWeightProperties(this.rankProfile);
        }

        private void deriveFilterFields(RankProfile rp) {
            this.filterFields.addAll(rp.allFilterFields());
        }

        public void deriveRankingFeatures(RankProfile rankProfile) {
            this.firstPhaseRanking = rankProfile.getFirstPhaseRanking();
            this.secondPhaseRanking = rankProfile.getSecondPhaseRanking();
            this.summaryFeatures = new LinkedHashSet<ReferenceNode>(rankProfile.getSummaryFeatures());
            this.rankFeatures = rankProfile.getRankFeatures();
            this.rerankCount = rankProfile.getRerankCount();
            this.matchPhaseSettings = rankProfile.getMatchPhaseSettings();
            this.numThreadsPerSearch = rankProfile.getNumThreadsPerSearch();
            this.minHitsPerThread = rankProfile.getMinHitsPerThread();
            this.numSearchPartitions = rankProfile.getNumSearchPartitions();
            this.termwiseLimit = rankProfile.getTermwiseLimit();
            this.keepRankCount = rankProfile.getKeepRankCount();
            this.rankScoreDropLimit = rankProfile.getRankScoreDropLimit();
            this.ignoreDefaultRankFeatures = rankProfile.getIgnoreDefaultRankFeatures();
            this.rankProperties = new ArrayList<RankProfile.RankProperty>(rankProfile.getRankProperties());
            this.derivePropertiesAndSummaryFeaturesFromMacros(rankProfile.getMacros());
        }

        private void derivePropertiesAndSummaryFeaturesFromMacros(Map<String, RankProfile.Macro> macros) {
            if (macros.isEmpty()) {
                return;
            }
            LinkedHashMap<String, ExpressionFunction> expressionMacros = new LinkedHashMap<String, ExpressionFunction>();
            for (Map.Entry<String, RankProfile.Macro> entry : macros.entrySet()) {
                expressionMacros.put(entry.getKey(), entry.getValue().toExpressionMacro());
            }
            LinkedHashMap<String, String> macroProperties = new LinkedHashMap<String, String>();
            macroProperties.putAll(this.deriveMacroProperties(expressionMacros));
            if (this.firstPhaseRanking != null) {
                macroProperties.putAll(this.firstPhaseRanking.getRankProperties(new ArrayList(expressionMacros.values())));
            }
            if (this.secondPhaseRanking != null) {
                macroProperties.putAll(this.secondPhaseRanking.getRankProperties(new ArrayList(expressionMacros.values())));
            }
            for (Map.Entry entry : macroProperties.entrySet()) {
                this.rankProperties.add(new RankProfile.RankProperty((String)entry.getKey(), (String)entry.getValue()));
            }
            SerializationContext serializationContext = new SerializationContext(expressionMacros.values(), null, macroProperties);
            this.replaceMacroSummaryFeatures(serializationContext);
        }

        private Map<String, String> deriveMacroProperties(Map<String, ExpressionFunction> eMacros) {
            SerializationContext context = new SerializationContext(eMacros);
            for (Map.Entry<String, ExpressionFunction> e : eMacros.entrySet()) {
                String script = e.getValue().getBody().getRoot().toString(context, null, null);
                context.addFunctionSerialization(RankingExpression.propertyName((String)e.getKey()), script);
            }
            return context.serializedFunctions();
        }

        private void replaceMacroSummaryFeatures(SerializationContext context) {
            if (this.summaryFeatures == null) {
                return;
            }
            LinkedHashMap<String, ReferenceNode> macroSummaryFeatures = new LinkedHashMap<String, ReferenceNode>();
            Iterator<ReferenceNode> i = this.summaryFeatures.iterator();
            while (i.hasNext()) {
                ReferenceNode referenceNode = i.next();
                if (context.getFunction(referenceNode.getName()) == null) continue;
                context.addFunctionSerialization(RankingExpression.propertyName((String)referenceNode.getName()), referenceNode.toString(context, null, null));
                ReferenceNode newReferenceNode = new ReferenceNode("rankingExpression(" + referenceNode.getName() + ")", referenceNode.getArguments().expressions(), referenceNode.getOutput());
                macroSummaryFeatures.put(referenceNode.getName(), newReferenceNode);
                i.remove();
            }
            for (Map.Entry e : macroSummaryFeatures.entrySet()) {
                this.summaryFeatures.add((ReferenceNode)e.getValue());
            }
        }

        private void deriveWeightProperties(RankProfile rankProfile) {
            for (RankProfile.RankSetting setting : rankProfile.rankSettings()) {
                if (!setting.getType().equals((Object)RankProfile.RankSetting.Type.WEIGHT)) continue;
                this.boostAndWeightRankProperties.add(new RankProfile.RankProperty("vespa.fieldweight." + setting.getFieldName(), String.valueOf(setting.getIntValue())));
            }
        }

        private void deriveRankTypeSetting(RankProfile rankProfile, AttributeFields attributeFields) {
            Iterator<RankProfile.RankSetting> i = rankProfile.rankSettingIterator();
            while (i.hasNext()) {
                RankProfile.RankSetting setting = i.next();
                if (!setting.getType().equals((Object)RankProfile.RankSetting.Type.RANKTYPE)) continue;
                this.deriveNativeRankTypeSetting(setting.getFieldName(), (RankType)((Object)setting.getValue()), attributeFields, this.hasDefaultRankTypeSetting(rankProfile, setting.getFieldName()));
            }
        }

        public void deriveNativeRankTypeSetting(String fieldName, RankType rankType, AttributeFields attributeFields, boolean isDefaultSetting) {
            if (isDefaultSetting) {
                return;
            }
            NativeRankTypeDefinition definition = this.nativeRankTypeDefinitions.getRankTypeDefinition(rankType);
            if (definition == null) {
                throw new IllegalArgumentException("In field '" + fieldName + "': " + (Object)((Object)rankType) + " is known but has no implementation. Supported rank types: " + this.nativeRankTypeDefinitions.types().keySet());
            }
            FieldRankSettings settings = this.deriveFieldRankSettings(fieldName);
            Iterator<NativeTable> i = definition.rankSettingIterator();
            while (i.hasNext()) {
                NativeTable table = i.next();
                if ((!FieldRankSettings.isIndexFieldTable(table) || attributeFields.getAttribute(fieldName) != null) && (!FieldRankSettings.isAttributeFieldTable(table) || attributeFields.getAttribute(fieldName) == null)) continue;
                settings.addTable(table);
            }
        }

        private boolean hasDefaultRankTypeSetting(RankProfile rankProfile, String fieldName) {
            RankProfile.RankSetting setting = rankProfile.getRankSetting(fieldName, RankProfile.RankSetting.Type.RANKTYPE);
            return setting != null && setting.getValue().equals((Object)RankType.DEFAULT);
        }

        public FieldRankSettings deriveFieldRankSettings(String fieldName) {
            FieldRankSettings settings = this.fieldRankSettings.get(fieldName);
            if (settings == null) {
                settings = new FieldRankSettings(fieldName);
                this.fieldRankSettings.put(fieldName, settings);
            }
            return settings;
        }

        public Map<String, String> derive() {
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            int i = 0;
            for (RankProfile.RankProperty property : this.rankProperties) {
                if ("rankingExpression(firstphase).rankingScript".equals(property.getName())) {
                    try {
                        this.firstPhaseRanking = new RankingExpression(property.getValue());
                        continue;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Could not parse second phase expression", e);
                    }
                }
                if ("rankingExpression(secondphase).rankingScript".equals(property.getName())) {
                    try {
                        this.secondPhaseRanking = new RankingExpression(property.getValue());
                        continue;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("Could not parse second phase expression", e);
                    }
                }
                properties.put(property.getName() + ".part" + i, property.getValue());
                ++i;
            }
            properties.putAll(this.deriveRankingPhaseRankProperties(this.firstPhaseRanking, "firstphase"));
            properties.putAll(this.deriveRankingPhaseRankProperties(this.secondPhaseRanking, "secondphase"));
            for (FieldRankSettings settings : this.fieldRankSettings.values()) {
                properties.putAll(settings.deriveRankProperties(i));
            }
            i = 0;
            for (RankProfile.RankProperty property : this.boostAndWeightRankProperties) {
                properties.put(property.getName() + ".part" + i, property.getValue());
                ++i;
            }
            i = 0;
            for (ReferenceNode feature : this.summaryFeatures) {
                properties.put("vespa.summary.feature.part" + i, feature.toString());
                ++i;
            }
            i = 0;
            for (ReferenceNode feature : this.rankFeatures) {
                properties.put("vespa.dump.feature.part" + i, feature.toString());
                ++i;
            }
            if (this.numThreadsPerSearch > 0) {
                properties.put("vespa.matching.numthreadspersearch", this.numThreadsPerSearch + "");
            }
            if (this.minHitsPerThread > 0) {
                properties.put("vespa.matching.minhitsperthread", this.minHitsPerThread + "");
            }
            if (this.numSearchPartitions >= 0) {
                properties.put("vespa.matching.numsearchpartitions", this.numSearchPartitions + "");
            }
            if (this.termwiseLimit < 1.0) {
                properties.put("vespa.matching.termwise_limit", this.termwiseLimit + "");
            }
            if (this.matchPhaseSettings != null) {
                properties.put("vespa.matchphase.degradation.attribute", this.matchPhaseSettings.getAttribute());
                properties.put("vespa.matchphase.degradation.ascendingorder", this.matchPhaseSettings.getAscending() + "");
                properties.put("vespa.matchphase.degradation.maxhits", this.matchPhaseSettings.getMaxHits() + "");
                properties.put("vespa.matchphase.degradation.maxfiltercoverage", this.matchPhaseSettings.getMaxFilterCoverage() + "");
                properties.put("vespa.matchphase.degradation.samplepercentage", this.matchPhaseSettings.getEvaluationPoint() + "");
                properties.put("vespa.matchphase.degradation.postfiltermultiplier", this.matchPhaseSettings.getPrePostFilterTippingPoint() + "");
                RankProfile.DiversitySettings diversitySettings = this.rankProfile.getMatchPhaseSettings().getDiversity();
                if (diversitySettings != null) {
                    properties.put("vespa.matchphase.diversity.attribute", diversitySettings.getAttribute());
                    properties.put("vespa.matchphase.diversity.mingroups", String.valueOf(diversitySettings.getMinGroups()));
                    properties.put("vespa.matchphase.diversity.cutoff.factor", String.valueOf(diversitySettings.getCutoffFactor()));
                    properties.put("vespa.matchphase.diversity.cutoff.strategy", String.valueOf(diversitySettings.getCutoffStrategy()));
                }
            }
            if (this.rerankCount > -1) {
                properties.put("vespa.hitcollector.heapsize", this.rerankCount + "");
            }
            if (this.keepRankCount > -1) {
                properties.put("vespa.hitcollector.arraysize", this.keepRankCount + "");
            }
            if (this.rankScoreDropLimit > -1.7976931348623157E308) {
                properties.put("vespa.hitcollector.rankscoredroplimit", this.rankScoreDropLimit + "");
            }
            if (this.ignoreDefaultRankFeatures) {
                properties.put("vespa.dump.ignoredefaultfeatures", String.valueOf(true));
            }
            for (String fieldName : this.filterFields) {
                properties.put("vespa.isfilterfield." + fieldName + ".part42", String.valueOf(true));
            }
            for (Map.Entry<String, String> attributeType : this.rankProfile.getAttributeTypes().entrySet()) {
                properties.put("vespa.type.attribute." + attributeType.getKey(), attributeType.getValue());
            }
            for (Map.Entry<String, String> queryFeatureType : this.rankProfile.getQueryFeatureTypes().entrySet()) {
                properties.put("vespa.type.query." + queryFeatureType.getKey(), queryFeatureType.getValue());
            }
            if (properties.size() >= 1000000) {
                throw new RuntimeException("Too many rank properties");
            }
            return properties;
        }

        private Map<String, String> deriveRankingPhaseRankProperties(RankingExpression expression, String phase) {
            LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
            if (expression == null) {
                return ret;
            }
            String name = expression.getName();
            if ("".equals(name)) {
                name = phase;
            }
            if (expression.getRoot() instanceof ReferenceNode) {
                ret.put("vespa.rank." + phase, expression.getRoot().toString());
            } else {
                ret.put("vespa.rank." + phase, "rankingExpression(" + name + ")");
                ret.put("rankingExpression(" + name + ").rankingScript", expression.getRoot().toString());
            }
            return ret;
        }
    }
}

