/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.test;

import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.ComponentInfo;
import com.yahoo.config.application.api.UnparsedConfigDefinition;
import com.yahoo.config.provision.Version;
import com.yahoo.io.IOUtils;
import com.yahoo.io.reader.NamedReader;
import com.yahoo.path.Path;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.SearchBuilder;
import com.yahoo.searchdefinition.parser.ParseException;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MockApplicationPackage
implements ApplicationPackage {
    public static final String MUSIC_SEARCHDEFINITION = MockApplicationPackage.createSearchDefinition("music", "foo");
    public static final String BOOK_SEARCHDEFINITION = MockApplicationPackage.createSearchDefinition("book", "bar");
    private final String hostsS;
    private final String servicesS;
    private final List<String> searchDefinitions;
    private final String searchDefinitionDir;
    private final Optional<String> deploymentSpec;
    private final Optional<String> validationOverrides;
    private final boolean failOnValidateXml;
    private static final String emptyServices = "<services version=\"1.0\">  <admin version=\"2.0\">    <adminserver hostalias=\"node1\" />  </admin></services>";
    private static final String emptyHosts = "<hosts>  <host name=\"localhost\">    <alias>node1</alias>  </host></hosts>";

    private MockApplicationPackage(String hosts, String services, List<String> searchDefinitions, String searchDefinitionDir, String deploymentSpec, String validationOverrides, boolean failOnValidateXml) {
        this.hostsS = hosts;
        this.servicesS = services;
        this.searchDefinitions = searchDefinitions;
        this.searchDefinitionDir = searchDefinitionDir;
        this.deploymentSpec = Optional.ofNullable(deploymentSpec);
        this.validationOverrides = Optional.ofNullable(validationOverrides);
        this.failOnValidateXml = failOnValidateXml;
    }

    public String getApplicationName() {
        return "mock application";
    }

    public Reader getServices() {
        return new StringReader(this.servicesS);
    }

    public Reader getHosts() {
        if (this.hostsS == null) {
            return null;
        }
        return new StringReader(this.hostsS);
    }

    public List<NamedReader> getSearchDefinitions() {
        ArrayList<NamedReader> readers = new ArrayList<NamedReader>();
        SearchBuilder searchBuilder = new SearchBuilder(this, new RankProfileRegistry());
        for (String sd : this.searchDefinitions) {
            try {
                String name = searchBuilder.importString(sd);
                readers.add(new NamedReader(name + ".sd", (Reader)new StringReader(sd)));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return readers;
    }

    public List<NamedReader> searchDefinitionContents() {
        return new ArrayList<NamedReader>();
    }

    public Map<ConfigDefinitionKey, UnparsedConfigDefinition> getAllExistingConfigDefs() {
        return Collections.emptyMap();
    }

    public List<NamedReader> getFiles(Path dir, String fileSuffix, boolean recurse) {
        return new ArrayList<NamedReader>();
    }

    public ApplicationFile getFile(Path file) {
        throw new UnsupportedOperationException();
    }

    public String getHostSource() {
        return "mock source";
    }

    public String getServicesSource() {
        return "mock source";
    }

    public Optional<Reader> getDeployment() {
        return this.deploymentSpec.map(StringReader::new);
    }

    public Optional<Reader> getValidationOverrides() {
        return this.validationOverrides.map(StringReader::new);
    }

    public List<ComponentInfo> getComponentsInfo(Version vespaVersion) {
        return Collections.emptyList();
    }

    public Reader getRankingExpression(String name) {
        File expressionFile = new File(this.searchDefinitionDir, name);
        try {
            return IOUtils.createReader((File)expressionFile, (String)"utf-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read ranking expression file '" + expressionFile.getAbsolutePath() + "'", e);
        }
    }

    public static ApplicationPackage createEmpty() {
        return new Builder().withHosts(emptyHosts).withServices(emptyServices).build();
    }

    public static ApplicationPackage fromSearchDefinitionDirectory(String dir) {
        return new Builder().withEmptyHosts().withEmptyServices().withSearchDefinitionDir(dir).build();
    }

    public static String createSearchDefinition(String name, String fieldName) {
        return "search " + name + " {  document " + name + " {    field " + fieldName + " type string {}  }}";
    }

    public void validateXML() throws IOException {
        if (this.failOnValidateXml) {
            throw new IllegalArgumentException("Error in application package");
        }
        throw new UnsupportedOperationException("This application package cannot validate XML");
    }

    public static class Builder {
        private String hosts = null;
        private String services = null;
        private List<String> searchDefinitions = Collections.emptyList();
        private String searchDefinitionDir = null;
        private String deploymentSpec = null;
        private String validationOverrides = null;
        private boolean failOnValidateXml = false;

        public Builder withEmptyHosts() {
            return this.withHosts(MockApplicationPackage.emptyHosts);
        }

        public Builder withHosts(String hosts) {
            this.hosts = hosts;
            return this;
        }

        public Builder withEmptyServices() {
            return this.withServices(MockApplicationPackage.emptyServices);
        }

        public Builder withServices(String services) {
            this.services = services;
            return this;
        }

        public Builder withSearchDefinition(String searchDefinition) {
            this.searchDefinitions = Collections.singletonList(searchDefinition);
            return this;
        }

        public Builder withSearchDefinitions(List<String> searchDefinition) {
            this.searchDefinitions = Collections.unmodifiableList(searchDefinition);
            return this;
        }

        public Builder withSearchDefinitionDir(String searchDefinitionDir) {
            this.searchDefinitionDir = searchDefinitionDir;
            return this;
        }

        public Builder withDeploymentSpec(String deploymentSpec) {
            this.deploymentSpec = deploymentSpec;
            return this;
        }

        public Builder withValidationOverrides(String validationOverrides) {
            this.validationOverrides = validationOverrides;
            return this;
        }

        public Builder failOnValidateXml() {
            this.failOnValidateXml = true;
            return this;
        }

        public ApplicationPackage build() {
            return new MockApplicationPackage(this.hosts, this.services, this.searchDefinitions, this.searchDefinitionDir, this.deploymentSpec, this.validationOverrides, this.failOnValidateXml);
        }
    }
}

