/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.producer;

import com.yahoo.config.model.ConfigModelRepo;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.ConfigProducer;
import com.yahoo.vespa.model.ConfigProducerRoot;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.filedistribution.FileDistributionConfigProducer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractConfigProducerRoot
extends AbstractConfigProducer<AbstractConfigProducer<?>>
implements ConfigProducerRoot {
    protected final Map<String, ConfigProducer> id2producer = new LinkedHashMap<String, ConfigProducer>();

    public AbstractConfigProducerRoot(String rootConfigId) {
        super(rootConfigId);
    }

    @Override
    public AbstractConfigProducerRoot getRoot() {
        return this;
    }

    public abstract FileDistributionConfigProducer getFileDistributionConfigProducer();

    public void freezeModelTopology() {
        this.freeze();
        this.setupConfigId("");
        this.aggregateDescendantServices();
    }

    public abstract ConfigModelRepo configModelRepo();

    public Optional<ConfigProducer> getConfigProducer(String configId) {
        return Optional.ofNullable(this.id2producer.get(configId));
    }

    public Optional<Service> getService(String configId) {
        return this.getConfigProducer(configId).filter(Service.class::isInstance).map(Service.class::cast);
    }
}

