/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.graph;

import com.yahoo.component.ComponentId;
import com.yahoo.config.model.graph.ModelNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelGraph {
    private final List<ModelNode> modelNodes;
    private final List<ModelNode> roots;

    public ModelGraph(List<ModelNode> modelNodes, List<ModelNode> roots) {
        this.modelNodes = modelNodes;
        this.roots = roots;
    }

    public List<ModelNode> topologicalSort() {
        DependencyMap dependencyMap = new DependencyMap(this.modelNodes);
        LinkedList<ModelNode> unprocessed = new LinkedList<ModelNode>();
        unprocessed.addAll(this.roots);
        ArrayList<ModelNode> sortedList = new ArrayList<ModelNode>();
        while (!unprocessed.isEmpty()) {
            ModelNode sortedNode = (ModelNode)unprocessed.remove();
            sortedList.add(sortedNode);
            for (ModelNode node : this.modelNodes) {
                if (!dependencyMap.dependsOn(node, sortedNode)) continue;
                dependencyMap.removeDependency(node, sortedNode);
                if (dependencyMap.hasDependencies(node)) continue;
                unprocessed.add(node);
            }
        }
        for (ModelNode node : this.modelNodes) {
            if (!dependencyMap.hasDependencies(node)) continue;
            throw new IllegalArgumentException("Unable to sort graph because it contains cycles");
        }
        return sortedList;
    }

    List<ModelNode> getNodes() {
        return this.modelNodes;
    }

    private static class DependencyMap {
        private final Map<ComponentId, Set<ComponentId>> map = new LinkedHashMap<ComponentId, Set<ComponentId>>();

        DependencyMap(List<ModelNode> modelNodes) {
            for (ModelNode node : modelNodes) {
                LinkedHashSet<ComponentId> ids = new LinkedHashSet<ComponentId>();
                ids.addAll(node.listDependencyIds());
                this.map.put(node.id, ids);
            }
        }

        public boolean dependsOn(ModelNode node, ModelNode sortedNode) {
            return this.map.get(node.id).contains(sortedNode.id);
        }

        public void removeDependency(ModelNode node, ModelNode sortedNode) {
            this.map.get(node.id).remove(sortedNode.id);
        }

        public boolean hasDependencies(ModelNode node) {
            return !this.map.get(node.id).isEmpty();
        }
    }
}

