/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.filedistribution;

import com.yahoo.cloud.config.filedistribution.FiledistributorConfig;
import com.yahoo.cloud.config.filedistribution.FiledistributorrpcConfig;
import com.yahoo.cloud.config.filedistribution.FilereferencesConfig;
import com.yahoo.config.FileReference;
import com.yahoo.config.model.api.FileDistribution;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.admin.FileDistributionOptions;
import com.yahoo.vespa.model.filedistribution.FileDistributor;
import java.util.Collection;

public class FileDistributorService
extends AbstractService
implements FiledistributorConfig.Producer,
FiledistributorrpcConfig.Producer,
FilereferencesConfig.Producer {
    private static final int BASEPORT = 19092;
    private final FileDistributor fileDistributor;
    private final FileDistributionOptions fileDistributionOptions;
    private final boolean sendAllFiles;

    private Collection<FileReference> getFileReferences() {
        if (this.sendAllFiles) {
            return this.fileDistributor.allFilesToSend();
        }
        return this.fileDistributor.filesToSendToHost(this.getHost());
    }

    public FileDistributorService(AbstractConfigProducer parent, String name, FileDistributor fileDistributor, FileDistributionOptions fileDistributionOptions, boolean sendAllFiles) {
        super(parent, name);
        this.portsMeta.on(0).tag("rpc");
        this.portsMeta.on(1).tag("torrent");
        this.portsMeta.on(2).tag("http").tag("state");
        this.setProp("clustertype", "filedistribution");
        this.setProp("clustername", "admin");
        this.fileDistributor = fileDistributor;
        this.fileDistributionOptions = fileDistributionOptions;
        this.sendAllFiles = sendAllFiles;
        this.monitorService();
    }

    @Override
    public String getStartupCommand() {
        return "exec $ROOT/sbin/vespa-filedistributor --configid " + this.getConfigId();
    }

    @Override
    public boolean getAutostartFlag() {
        return true;
    }

    @Override
    public boolean getAutorestartFlag() {
        return true;
    }

    @Override
    public int getPortCount() {
        return 3;
    }

    @Override
    public int getWantedPort() {
        return 19092;
    }

    public void getConfig(FiledistributorConfig.Builder builder) {
        this.fileDistributionOptions.getConfig(builder);
        builder.torrentport(this.getRelativePort(1));
        builder.stateport(this.getRelativePort(2));
        builder.hostname(this.getHostName());
        builder.filedbpath(FileDistribution.getDefaultFileDBPath().toString());
    }

    public void getConfig(FiledistributorrpcConfig.Builder builder) {
        builder.connectionspec("tcp/" + this.getHostName() + ":" + this.getRelativePort(0));
    }

    public void getConfig(FilereferencesConfig.Builder builder) {
        for (FileReference reference : this.getFileReferences()) {
            builder.filereferences(reference.value());
        }
    }
}

