/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content.cluster;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.yahoo.config.model.ConfigModelContext;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.model.producer.AbstractConfigProducerRoot;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.Zone;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.metrics.MetricsmanagerConfig;
import com.yahoo.vespa.config.content.FleetcontrollerConfig;
import com.yahoo.vespa.config.content.MessagetyperouteselectorpolicyConfig;
import com.yahoo.vespa.config.content.StorDistributionConfig;
import com.yahoo.vespa.config.content.core.StorDistributormanagerConfig;
import com.yahoo.vespa.model.AbstractService;
import com.yahoo.vespa.model.HostResource;
import com.yahoo.vespa.model.Service;
import com.yahoo.vespa.model.admin.Admin;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerCluster;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerClusterVerifier;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerComponent;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerConfigurer;
import com.yahoo.vespa.model.admin.clustercontroller.ClusterControllerContainer;
import com.yahoo.vespa.model.admin.monitoring.Metric;
import com.yahoo.vespa.model.admin.monitoring.MetricsConsumer;
import com.yahoo.vespa.model.admin.monitoring.Monitoring;
import com.yahoo.vespa.model.builder.xml.dom.ModelElement;
import com.yahoo.vespa.model.builder.xml.dom.NodesSpecification;
import com.yahoo.vespa.model.container.Container;
import com.yahoo.vespa.model.container.ContainerCluster;
import com.yahoo.vespa.model.container.ContainerModel;
import com.yahoo.vespa.model.container.xml.ContainerModelBuilder;
import com.yahoo.vespa.model.content.ClusterControllerConfig;
import com.yahoo.vespa.model.content.ContentSearch;
import com.yahoo.vespa.model.content.ContentSearchCluster;
import com.yahoo.vespa.model.content.DistributionBitCalculator;
import com.yahoo.vespa.model.content.DistributorCluster;
import com.yahoo.vespa.model.content.GlobalDistributionValidator;
import com.yahoo.vespa.model.content.IndexedHierarchicDistributionValidator;
import com.yahoo.vespa.model.content.Redundancy;
import com.yahoo.vespa.model.content.StorageGroup;
import com.yahoo.vespa.model.content.TuningDispatch;
import com.yahoo.vespa.model.content.cluster.DocumentSelectionBuilder;
import com.yahoo.vespa.model.content.cluster.DomContentSearchBuilder;
import com.yahoo.vespa.model.content.cluster.DomDispatchBuilder;
import com.yahoo.vespa.model.content.cluster.DomSearchCoverageBuilder;
import com.yahoo.vespa.model.content.cluster.DomTuningDispatchBuilder;
import com.yahoo.vespa.model.content.cluster.EngineFactoryBuilder;
import com.yahoo.vespa.model.content.cluster.GlobalDistributionBuilder;
import com.yahoo.vespa.model.content.cluster.RedundancyBuilder;
import com.yahoo.vespa.model.content.cluster.SearchDefinitionBuilder;
import com.yahoo.vespa.model.content.engines.PersistenceEngine;
import com.yahoo.vespa.model.content.engines.ProtonEngine;
import com.yahoo.vespa.model.content.engines.VDSEngine;
import com.yahoo.vespa.model.content.storagecluster.StorageCluster;
import com.yahoo.vespa.model.routing.DocumentProtocol;
import com.yahoo.vespa.model.search.IndexedSearchCluster;
import com.yahoo.vespa.model.search.MultilevelDispatchValidator;
import com.yahoo.vespa.model.search.Tuning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.w3c.dom.Element;

public class ContentCluster
extends AbstractConfigProducer
implements StorDistributionConfig.Producer,
StorDistributormanagerConfig.Producer,
FleetcontrollerConfig.Producer,
MetricsmanagerConfig.Producer,
MessagetyperouteselectorpolicyConfig.Producer {
    private String documentSelection;
    ContentSearchCluster search;
    private final Map<String, NewDocumentType> documentDefinitions;
    private final Set<NewDocumentType> globallyDistributedDocuments;
    StorageGroup rootGroup;
    StorageCluster storageNodes;
    DistributorCluster distributorNodes;
    private Redundancy redundancy;
    ClusterControllerConfig clusterControllerConfig;
    PersistenceEngine.PersistenceFactory persistenceFactory;
    String clusterName;
    Integer maxNodesPerMerge;
    private Zone zone;
    private ContainerCluster clusterControllers;
    DistributionMode distributionMode;
    public static Map<String, Integer> METRIC_INDEX_MAP = new TreeMap<String, Integer>();

    private ContentCluster(AbstractConfigProducer parent, String clusterName, Map<String, NewDocumentType> documentDefinitions, Set<NewDocumentType> globallyDistributedDocuments, String routingSelection, Redundancy redundancy, Zone zone) {
        super(parent, clusterName);
        this.clusterName = clusterName;
        this.documentDefinitions = documentDefinitions;
        this.globallyDistributedDocuments = globallyDistributedDocuments;
        this.documentSelection = routingSelection;
        this.redundancy = redundancy;
        this.zone = zone;
    }

    public void prepare() {
        this.search.prepare();
        if (this.clusterControllers != null) {
            this.clusterControllers.prepare();
        }
    }

    public ContainerCluster getClusterControllers() {
        return this.clusterControllers;
    }

    public DistributionMode getDistributionMode() {
        if (this.distributionMode != null) {
            return this.distributionMode;
        }
        return this.getPersistence().getDefaultDistributionMode();
    }

    public boolean isMemfilePersistence() {
        return this.persistenceFactory instanceof VDSEngine.Factory;
    }

    public static String getClusterName(ModelElement clusterElem) {
        String clusterName = clusterElem.getStringAttribute("id");
        if (clusterName == null) {
            clusterName = "content";
        }
        return clusterName;
    }

    public String getName() {
        return this.clusterName;
    }

    public String getRoutingSelector() {
        return this.documentSelection;
    }

    public DistributorCluster getDistributorNodes() {
        return this.distributorNodes;
    }

    public StorageCluster getStorageNodes() {
        return this.storageNodes;
    }

    public ClusterControllerConfig getClusterControllerConfig() {
        return this.clusterControllerConfig;
    }

    public PersistenceEngine.PersistenceFactory getPersistence() {
        return this.persistenceFactory;
    }

    public Map<String, NewDocumentType> getDocumentDefinitions() {
        return this.documentDefinitions;
    }

    public final ContentSearchCluster getSearch() {
        return this.search;
    }

    public Redundancy redundancy() {
        return this.redundancy;
    }

    public void getConfig(MessagetyperouteselectorpolicyConfig.Builder builder) {
        if (!this.getSearch().hasIndexedCluster()) {
            return;
        }
        builder.defaultroute(DocumentProtocol.getDirectRouteName(this.getConfigId())).route(new MessagetyperouteselectorpolicyConfig.Route.Builder().messagetype(100004).name(DocumentProtocol.getIndexedRouteName(this.getConfigId()))).route(new MessagetyperouteselectorpolicyConfig.Route.Builder().messagetype(100005).name(DocumentProtocol.getIndexedRouteName(this.getConfigId()))).route(new MessagetyperouteselectorpolicyConfig.Route.Builder().messagetype(100006).name(DocumentProtocol.getIndexedRouteName(this.getConfigId())));
    }

    public StorageGroup getRootGroup() {
        return this.rootGroup;
    }

    public void getConfig(StorDistributionConfig.Builder builder) {
        if (this.rootGroup != null) {
            builder.group.addAll(this.rootGroup.getGroupStructureConfig());
        }
        if (this.redundancy != null) {
            this.redundancy.getConfig(builder);
        }
        if (this.search.usesHierarchicDistribution()) {
            builder.active_per_leaf_group(true);
        }
    }

    int getNodeCount() {
        return this.storageNodes.getChildren().size();
    }

    int getNodeCountPerGroup() {
        return this.rootGroup != null ? this.getNodeCount() / this.rootGroup.getNumberOfLeafGroups() : this.getNodeCount();
    }

    public void getConfig(FleetcontrollerConfig.Builder builder) {
        builder.ideal_distribution_bits(this.distributionBits());
        if (this.getNodeCount() < 5) {
            builder.min_storage_up_count(1);
            builder.min_distributor_up_ratio(0.0);
            builder.min_storage_up_ratio(0.0);
        }
    }

    public void getConfig(StorDistributormanagerConfig.Builder builder) {
        builder.minsplitcount(this.distributionBits());
        if (this.maxNodesPerMerge != null) {
            builder.maximum_nodes_per_merge(this.maxNodesPerMerge.intValue());
        }
    }

    public int distributionBits() {
        if (this.zone.environment() == Environment.prod && !this.zone.equals((Object)Zone.defaultZone())) {
            return 16;
        }
        return DistributionBitCalculator.getDistributionBits(this.getNodeCountPerGroup(), this.getDistributionMode());
    }

    @Override
    public void validate() throws Exception {
        super.validate();
        if (this.search.usesHierarchicDistribution() && !this.isHostedVespa()) {
            new IndexedHierarchicDistributionValidator(this.search.getClusterName(), this.rootGroup, this.redundancy, this.search.getIndexed().getTuning().dispatch.policy).validate();
            if (this.search.getIndexed().useMultilevelDispatchSetup()) {
                throw new IllegalArgumentException("In indexed content cluster '" + this.search.getClusterName() + "': Using multi-level dispatch setup is not supported when using hierarchical distribution.");
            }
        }
        new GlobalDistributionValidator().validate(this.documentDefinitions, this.globallyDistributedDocuments, this.redundancy);
    }

    public static MetricsmanagerConfig.Consumer.Builder getMetricBuilder(String name, MetricsmanagerConfig.Builder builder) {
        Integer index = METRIC_INDEX_MAP.get(name);
        if (index != null) {
            return (MetricsmanagerConfig.Consumer.Builder)builder.consumer.get(index);
        }
        MetricsmanagerConfig.Consumer.Builder retVal = new MetricsmanagerConfig.Consumer.Builder();
        retVal.name(name);
        builder.consumer(retVal);
        return retVal;
    }

    public void getConfig(MetricsmanagerConfig.Builder builder) {
        Monitoring monitoring = this.getMonitoringService();
        if (monitoring != null) {
            builder.snapshot(new MetricsmanagerConfig.Snapshot.Builder().periods(monitoring.getIntervalSeconds()).periods(Integer.valueOf(300)));
        }
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("status").addedmetrics("*").removedtags("partofsum"));
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("log").tags("logdefault").removedtags("loadtype"));
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("yamas").tags("yamasdefault").removedtags("loadtype"));
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("health"));
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("fleetcontroller"));
        builder.consumer(new MetricsmanagerConfig.Consumer.Builder().name("statereporter").addedmetrics("*").removedtags("thread").tags("disk"));
        Map<String, MetricsConsumer> consumers = this.getRoot().getAdmin().getLegacyUserMetricsConsumers();
        if (consumers != null) {
            for (Map.Entry<String, MetricsConsumer> e : consumers.entrySet()) {
                MetricsmanagerConfig.Consumer.Builder b = ContentCluster.getMetricBuilder(e.getKey(), builder);
                for (Metric m : e.getValue().getMetrics().values()) {
                    b.addedmetrics(m.name);
                }
            }
        }
    }

    static {
        METRIC_INDEX_MAP.put("status", 0);
        METRIC_INDEX_MAP.put("log", 1);
        METRIC_INDEX_MAP.put("yamas", 2);
        METRIC_INDEX_MAP.put("health", 3);
        METRIC_INDEX_MAP.put("fleetcontroller", 4);
        METRIC_INDEX_MAP.put("statereporter", 5);
    }

    public static class Builder {
        private final Admin admin;

        public Builder(Admin admin) {
            this.admin = admin;
        }

        public ContentCluster build(Collection<ContainerModel> containers, ConfigModelContext context, Element w3cContentElement) {
            ModelElement contentElement = new ModelElement(w3cContentElement);
            ModelElement documentsElement = contentElement.getChild("documents");
            Map<String, NewDocumentType> documentDefinitions = new SearchDefinitionBuilder().build(context.getDeployState().getDocumentModel().getDocumentManager(), documentsElement);
            String routingSelection = new DocumentSelectionBuilder().build(documentsElement);
            Redundancy redundancy = new RedundancyBuilder().build(contentElement);
            Set<NewDocumentType> globallyDistributedDocuments = new GlobalDistributionBuilder(documentDefinitions).build(documentsElement);
            ContentCluster c = new ContentCluster(context.getParentProducer(), ContentCluster.getClusterName(contentElement), documentDefinitions, globallyDistributedDocuments, routingSelection, redundancy, context.getDeployState().getProperties().zone());
            c.clusterControllerConfig = (ClusterControllerConfig)new ClusterControllerConfig.Builder(ContentCluster.getClusterName(contentElement), contentElement).build(c, contentElement.getXml());
            c.search = (ContentSearchCluster)new ContentSearchCluster.Builder(documentDefinitions, globallyDistributedDocuments).build(c, contentElement.getXml());
            c.persistenceFactory = new EngineFactoryBuilder().build(contentElement, c);
            c.storageNodes = (StorageCluster)new StorageCluster.Builder().build(c, w3cContentElement);
            c.distributorNodes = (DistributorCluster)new DistributorCluster.Builder(c).build(c, w3cContentElement);
            c.rootGroup = new StorageGroup.Builder(contentElement, c, context).buildRootGroup();
            this.validateThatGroupSiblingsAreUnique(c.clusterName, c.rootGroup);
            redundancy.setExplicitGroups(c.getRootGroup().getNumberOfLeafGroups());
            c.search.handleRedundancy(redundancy);
            IndexedSearchCluster index = c.search.getIndexed();
            if (index != null) {
                this.setupIndexedCluster(index, contentElement);
            }
            if (c.search.hasIndexedCluster() && !(c.persistenceFactory instanceof ProtonEngine.Factory)) {
                throw new RuntimeException("If you have indexed search you need to have proton as engine");
            }
            if (c.isMemfilePersistence()) {
                this.admin.deployLogger().log(Level.WARNING, "'vds' engine is deprecated and will soon be removed. 'proton' is only recommended engine.");
            }
            if (documentsElement != null) {
                ModelElement e = documentsElement.getChild("document-processing");
                if (e != null) {
                    this.setupDocumentProcessing(c, e);
                }
            } else if (c.persistenceFactory != null) {
                throw new IllegalArgumentException("The specified content engine requires the <documents> element to be specified.");
            }
            ModelElement tuning = contentElement.getChild("tuning");
            if (tuning != null) {
                this.setupTuning(c, tuning);
            }
            if (context.getParentProducer().getRoot() == null) {
                return c;
            }
            this.addClusterControllers(containers, context, c.rootGroup, contentElement, c.clusterName, c);
            return c;
        }

        private void setupIndexedCluster(IndexedSearchCluster index, ModelElement element) {
            Double visibilityDelay;
            ContentSearch search = DomContentSearchBuilder.build(element);
            Double queryTimeout = search.getQueryTimeout();
            if (queryTimeout != null) {
                Preconditions.checkState((index.getQueryTimeout() == null ? 1 : 0) != 0, (Object)"You may not specify query-timeout in both proton and content.");
                index.setQueryTimeout(queryTimeout);
            }
            if ((visibilityDelay = search.getVisibilityDelay()) != null) {
                index.setVisibilityDelay(visibilityDelay);
            }
            index.setSearchCoverage(DomSearchCoverageBuilder.build(element));
            index.setDispatchSpec(DomDispatchBuilder.build(element));
            if (index.useMultilevelDispatchSetup()) {
                new MultilevelDispatchValidator(index.getClusterName(), index.getDispatchSpec(), index.getSearchNodes()).validate();
            }
            TuningDispatch tuningDispatch = DomTuningDispatchBuilder.build(element);
            Integer maxHitsPerPartition = tuningDispatch.getMaxHitsPerPartition();
            Boolean useLocalNode = tuningDispatch.getUseLocalNode();
            if (index.getTuning() == null) {
                index.setTuning(new Tuning(index));
            }
            if (index.getTuning().dispatch == null) {
                index.getTuning().dispatch = new Tuning.Dispatch();
            }
            if (maxHitsPerPartition != null) {
                index.getTuning().dispatch.maxHitsPerPartition = maxHitsPerPartition;
            }
            if (useLocalNode != null) {
                index.getTuning().dispatch.useLocalNode = useLocalNode;
            }
            index.getTuning().dispatch.minGroupCoverage = tuningDispatch.getMinGroupCoverage();
            index.getTuning().dispatch.minActiveDocsCoverage = tuningDispatch.getMinActiveDocsCoverage();
            index.getTuning().dispatch.policy = tuningDispatch.getDispatchPolicy();
        }

        private void setupDocumentProcessing(ContentCluster c, ModelElement e) {
            String docprocChain;
            String docprocCluster = e.getStringAttribute("cluster");
            if (docprocCluster != null) {
                docprocCluster = docprocCluster.trim();
            }
            if (c.getSearch().hasIndexedCluster() && docprocCluster != null && !docprocCluster.isEmpty()) {
                c.getSearch().getIndexed().setIndexingClusterName(docprocCluster);
            }
            if ((docprocChain = e.getStringAttribute("chain")) != null) {
                docprocChain = docprocChain.trim();
            }
            if (c.getSearch().hasIndexedCluster() && docprocChain != null && !docprocChain.isEmpty()) {
                c.getSearch().getIndexed().setIndexingChainName(docprocChain);
            }
        }

        private void setupTuning(ContentCluster c, ModelElement tuning) {
            Integer attr;
            ModelElement merges;
            String attr2;
            ModelElement distribution = tuning.getChild("distribution");
            if (distribution != null && (attr2 = distribution.getStringAttribute("type")) != null) {
                if (attr2.toLowerCase().equals("strict")) {
                    c.distributionMode = DistributionMode.STRICT;
                } else if (attr2.toLowerCase().equals("loose")) {
                    c.distributionMode = DistributionMode.LOOSE;
                } else if (attr2.toLowerCase().equals("legacy")) {
                    c.distributionMode = DistributionMode.LEGACY;
                } else {
                    throw new IllegalStateException("Distribution type " + attr2 + " not supported.");
                }
            }
            if ((merges = tuning.getChild("merges")) != null && (attr = merges.getIntegerAttribute("max-nodes-per-merge")) != null) {
                c.maxNodesPerMerge = attr;
            }
        }

        private void validateGroupSiblings(String cluster, StorageGroup group) {
            HashSet<String> siblings = new HashSet<String>();
            for (StorageGroup g : group.getSubgroups()) {
                String name = g.getName();
                if (siblings.contains(name)) {
                    throw new IllegalArgumentException("Cluster '" + cluster + "' has multiple groups with name '" + name + "' in the same subgroup. Group sibling names must be unique.");
                }
                siblings.add(name);
            }
        }

        private void validateThatGroupSiblingsAreUnique(String cluster, StorageGroup group) {
            if (group == null) {
                return;
            }
            this.validateGroupSiblings(cluster, group);
            for (StorageGroup g : group.getSubgroups()) {
                this.validateThatGroupSiblingsAreUnique(cluster, g);
            }
        }

        private void addClusterControllers(Collection<ContainerModel> containers, ConfigModelContext context, StorageGroup rootGroup, ModelElement contentElement, String contentClusterName, ContentCluster contentCluster) {
            ContainerCluster clusterControllers;
            if (this.admin == null) {
                return;
            }
            if (contentCluster.getPersistence() == null) {
                return;
            }
            ContentCluster overlappingCluster = this.findOverlappingCluster(context.getParentProducer().getRoot(), contentCluster);
            if (overlappingCluster != null && overlappingCluster.getClusterControllers() != null) {
                clusterControllers = overlappingCluster.getClusterControllers();
            } else if (this.admin.multitenant()) {
                String clusterName = contentClusterName + "-controllers";
                NodesSpecification nodesSpecification = NodesSpecification.optionalDedicatedFromParent(contentElement.getChild("controllers"), context.getDeployState().getWantedNodeVespaVersion()).orElse(NodesSpecification.nonDedicated(3, context.getDeployState().getWantedNodeVespaVersion()));
                Collection<HostResource> hosts = nodesSpecification.isDedicated() ? this.getControllerHosts(nodesSpecification, this.admin, clusterName, context) : this.drawControllerHosts(nodesSpecification.count(), rootGroup, containers);
                clusterControllers = this.createClusterControllers(new ClusterControllerCluster(contentCluster, "standalone"), hosts, clusterName, true);
                contentCluster.clusterControllers = clusterControllers;
            } else {
                clusterControllers = this.admin.getClusterControllers();
                if (clusterControllers == null) {
                    List<HostResource> hosts = this.admin.getClusterControllerHosts();
                    if (hosts.size() > 1) {
                        this.admin.deployLogger().log(Level.INFO, "When having content cluster(s) and more than 1 config server it is recommended to configure cluster controllers explicitly.");
                    }
                    clusterControllers = this.createClusterControllers(this.admin, hosts, "cluster-controllers", false);
                    this.admin.setClusterControllers(clusterControllers);
                }
            }
            this.addClusterControllerComponentsForThisCluster(clusterControllers, contentCluster);
        }

        private ContentCluster findOverlappingCluster(AbstractConfigProducerRoot root, ContentCluster contentCluster) {
            for (ContentCluster otherContentCluster : root.getChildrenByTypeRecursive(ContentCluster.class)) {
                if (otherContentCluster == contentCluster || !this.overlaps(contentCluster, otherContentCluster)) continue;
                return otherContentCluster;
            }
            return null;
        }

        private boolean overlaps(ContentCluster c1, ContentCluster c2) {
            Set c2Hosts;
            Set c1Hosts = c1.getRootGroup().recursiveGetNodes().stream().map(AbstractService::getHostResource).collect(Collectors.toSet());
            return !Sets.intersection(c1Hosts, c2Hosts = c2.getRootGroup().recursiveGetNodes().stream().map(AbstractService::getHostResource).collect(Collectors.toSet())).isEmpty();
        }

        private Collection<HostResource> getControllerHosts(NodesSpecification nodesSpecification, Admin admin, String clusterName, ConfigModelContext context) {
            return nodesSpecification.provision(admin.getHostSystem(), ClusterSpec.Type.admin, ClusterSpec.Id.from((String)clusterName), context.getDeployLogger()).keySet();
        }

        private List<HostResource> drawControllerHosts(int count, StorageGroup rootGroup, Collection<ContainerModel> containers) {
            List<HostResource> hosts = this.drawContentHostsRecursively(count, rootGroup);
            if (hosts.size() % 2 == 0) {
                hosts = hosts.subList(0, hosts.size() - 1);
            }
            return hosts;
        }

        private List<HostResource> drawContainerHosts(int count, Collection<ContainerModel> containerClusters, Set<HostResource> usedHosts) {
            if (containerClusters.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<HostResource> allHosts = new ArrayList<HostResource>();
            for (ContainerCluster cluster : this.clustersSortedByName(containerClusters)) {
                allHosts.addAll(this.hostResourcesSortedByIndex(cluster));
            }
            List uniqueHostsWithoutClusterController = allHosts.stream().filter(h -> !usedHosts.contains(h)).filter(h -> !this.hostHasClusterController(h.getHostName(), allHosts)).distinct().collect(Collectors.toList());
            return uniqueHostsWithoutClusterController.subList(0, Math.min(uniqueHostsWithoutClusterController.size(), count));
        }

        private List<ContainerCluster> clustersSortedByName(Collection<ContainerModel> containerModels) {
            return containerModels.stream().map(ContainerModel::getCluster).sorted(Comparator.comparing(ContainerCluster::getName)).collect(Collectors.toList());
        }

        private List<HostResource> hostResourcesSortedByIndex(ContainerCluster cluster) {
            return cluster.getContainers().stream().sorted(Comparator.comparing(Container::index)).map(AbstractService::getHostResource).collect(Collectors.toList());
        }

        private boolean hostHasClusterController(String hostname, List<HostResource> hosts) {
            for (HostResource host : hosts) {
                if (!host.getHostName().equals(hostname) || !this.hasClusterController(host)) continue;
                return true;
            }
            return false;
        }

        private boolean hasClusterController(HostResource host) {
            for (Service service : host.getServices()) {
                if (!(service instanceof ClusterControllerContainer)) continue;
                return true;
            }
            return false;
        }

        private List<HostResource> drawContentHostsRecursively(int count, StorageGroup group) {
            HashSet<HostResource> hosts = new HashSet<HostResource>();
            if (group.getNodes().isEmpty()) {
                int hostsPerSubgroup = (int)Math.ceil((double)count / (double)group.getSubgroups().size());
                for (StorageGroup subgroup : group.getSubgroups()) {
                    hosts.addAll(this.drawContentHostsRecursively(hostsPerSubgroup, subgroup));
                }
            } else {
                hosts.addAll(group.getNodes().stream().filter(node -> !node.isRetired()).map(AbstractService::getHostResource).collect(Collectors.toList()));
            }
            ArrayList<HostResource> sortedHosts = new ArrayList(hosts);
            Collections.sort(sortedHosts);
            sortedHosts = sortedHosts.subList(0, Math.min(count, hosts.size()));
            return sortedHosts;
        }

        private ContainerCluster createClusterControllers(AbstractConfigProducer parent, Collection<HostResource> hosts, String name, boolean multitenant) {
            ContainerCluster clusterControllers = new ContainerCluster(parent, name, name, new ClusterControllerClusterVerifier());
            ArrayList<Container> containers = new ArrayList<Container>();
            if (clusterControllers.getContainers().isEmpty()) {
                int index = 0;
                for (HostResource host : hosts) {
                    ClusterControllerContainer clusterControllerContainer = new ClusterControllerContainer((AbstractConfigProducer)clusterControllers, index, multitenant);
                    clusterControllerContainer.setHostResource(host);
                    clusterControllerContainer.initService();
                    clusterControllerContainer.setProp("clustertype", "admin").setProp("clustername", clusterControllers.getName()).setProp("index", String.valueOf(index));
                    containers.add(clusterControllerContainer);
                    ++index;
                }
            }
            clusterControllers.addContainers(containers);
            ContainerModelBuilder.addDefaultHandler_legacyBuilder(clusterControllers);
            return clusterControllers;
        }

        private void addClusterControllerComponentsForThisCluster(ContainerCluster clusterControllers, ContentCluster contentCluster) {
            int index = 0;
            for (Container container : clusterControllers.getContainers()) {
                if (!this.hasClusterControllerComponent(container)) {
                    container.addComponent(new ClusterControllerComponent());
                }
                container.addComponent(new ClusterControllerConfigurer(contentCluster, index++, clusterControllers.getContainers().size()));
            }
        }

        private boolean hasClusterControllerComponent(Container container) {
            for (Object o : container.getComponents().getComponents()) {
                if (!(o instanceof ClusterControllerComponent)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum DistributionMode {
        LEGACY,
        STRICT,
        LOOSE;

    }
}

