/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.admin;

import com.yahoo.binaryprefix.BinaryPrefix;
import com.yahoo.binaryprefix.BinaryScaledAmount;
import com.yahoo.cloud.config.filedistribution.FiledistributorConfig;

public class FileDistributionOptions
implements FiledistributorConfig.Producer {
    private BinaryScaledAmount uploadbitrate = new BinaryScaledAmount();
    private BinaryScaledAmount downloadbitrate = new BinaryScaledAmount();

    public static FileDistributionOptions defaultOptions() {
        return new FileDistributionOptions();
    }

    private FileDistributionOptions() {
    }

    public void downloadbitrate(BinaryScaledAmount amount) {
        this.ensureNonNegative(amount);
        this.downloadbitrate = amount;
    }

    public void uploadbitrate(BinaryScaledAmount amount) {
        this.ensureNonNegative(amount);
        this.uploadbitrate = amount;
    }

    private void ensureNonNegative(BinaryScaledAmount amount) {
        if (amount.amount < 0.0) {
            throw new IllegalArgumentException("Expected non-negative number, got " + amount.amount);
        }
    }

    private int byteRate(BinaryScaledAmount bitRate) {
        BinaryScaledAmount byteRate = bitRate.divide(8.0);
        return (int)byteRate.as(BinaryPrefix.unit);
    }

    public void getConfig(FiledistributorConfig.Builder builder) {
        builder.maxuploadspeed((double)this.byteRate(this.uploadbitrate));
        builder.maxdownloadspeed((double)this.byteRate(this.downloadbitrate));
    }
}

