/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.producer.AbstractConfigProducer;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.ProvisionLogger;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.model.Host;
import com.yahoo.vespa.model.HostResource;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class HostSystem
extends AbstractConfigProducer<Host> {
    private static Logger log = Logger.getLogger(HostSystem.class.getName());
    private Map<String, String> hostnames = new LinkedHashMap<String, String>();
    private final Map<String, HostResource> hostname2host = new LinkedHashMap<String, HostResource>();
    private final HostProvisioner provisioner;

    public HostSystem(AbstractConfigProducer parent, String name, HostProvisioner provisioner) {
        super(parent, name);
        this.provisioner = provisioner;
    }

    public HostResource getHostByHostname(String name) {
        if ("localhost.fortestingpurposesonly".equals(name)) {
            String localhost = "localhost";
            if (!this.getChildren().containsKey(localhost)) {
                new Host(this, localhost);
            }
            return new HostResource((Host)this.getChildren().get(localhost));
        }
        return this.hostname2host.get(name);
    }

    public String getCanonicalHostname(String hostname) throws UnknownHostException {
        if (!this.hostnames.containsKey(hostname)) {
            this.hostnames.put(hostname, HostSystem.lookupCanonicalHostname(hostname));
        }
        return this.hostnames.get(hostname);
    }

    public static String lookupCanonicalHostname(String hostname) throws UnknownHostException {
        return InetAddress.getByName(hostname).getCanonicalHostName();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (HostResource host : this.hostname2host.values()) {
            sb.append(host).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public HostResource getHost(String hostAlias) {
        HostSpec hostSpec = this.provisioner.allocateHost(hostAlias);
        for (HostResource resource : this.hostname2host.values()) {
            if (!resource.getHostName().equals(hostSpec.hostname())) continue;
            hostSpec.membership().ifPresent(resource::addClusterMembership);
            return resource;
        }
        return this.addNewHost(hostSpec);
    }

    private HostResource addNewHost(HostSpec hostSpec) {
        Host host = new Host(this, hostSpec.hostname());
        HostResource hostResource = new HostResource(host);
        hostResource.setFlavor(hostSpec.flavor());
        hostSpec.membership().ifPresent(hostResource::addClusterMembership);
        this.hostname2host.put(host.getHostName(), hostResource);
        log.log((Level)LogLevel.DEBUG, () -> "Added new host resource for " + host.getHostName() + " with flavor " + hostResource.getFlavor());
        return hostResource;
    }

    public List<HostResource> getHosts() {
        return this.hostname2host.values().stream().filter(host -> !host.getHost().runsConfigServer()).collect(Collectors.toList());
    }

    public Map<HostResource, ClusterMembership> allocateHosts(ClusterSpec cluster, Capacity capacity, int groups, DeployLogger logger) {
        List allocatedHosts = this.provisioner.prepare(cluster, capacity, groups, (ProvisionLogger)new ProvisionDeployLogger(logger));
        LinkedHashMap<HostResource, ClusterMembership> retAllocatedHosts = new LinkedHashMap<HostResource, ClusterMembership>();
        for (HostSpec spec : allocatedHosts) {
            HostResource host2 = this.getExistingHost(spec).orElseGet(() -> this.addNewHost(spec));
            retAllocatedHosts.put(host2, spec.membership().orElse(null));
            if (host2.getFlavor().isPresent()) continue;
            host2.setFlavor(spec.flavor());
            log.log((Level)LogLevel.DEBUG, () -> "Host resource " + host2.getHostName() + " had no flavor, setting to " + spec.flavor());
        }
        retAllocatedHosts.keySet().forEach(host -> log.log((Level)LogLevel.DEBUG, () -> "Allocated host " + host.getHostName() + " with flavor " + host.getFlavor()));
        return retAllocatedHosts;
    }

    private Optional<HostResource> getExistingHost(HostSpec key) {
        List hosts = this.hostname2host.values().stream().filter(resource -> resource.getHostName().equals(key.hostname())).collect(Collectors.toList());
        if (hosts.isEmpty()) {
            return Optional.empty();
        }
        log.log((Level)LogLevel.DEBUG, () -> "Found existing host resource for " + key.hostname() + " with flavor " + ((HostResource)hosts.get(0)).getFlavor());
        return Optional.of(hosts.get(0));
    }

    public void addBoundHost(HostResource host) {
        this.hostname2host.put(host.getHostName(), host);
    }

    Set<HostSpec> getHostSpecs() {
        return this.getHosts().stream().map(host -> new HostSpec(host.getHostName(), Collections.emptyList(), host.getFlavor(), host.primaryClusterMembership())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static class ProvisionDeployLogger
    implements ProvisionLogger {
        private final DeployLogger deployLogger;

        public ProvisionDeployLogger(DeployLogger deployLogger) {
            this.deployLogger = deployLogger;
        }

        public void log(Level level, String message) {
            this.deployLogger.log(level, message);
        }
    }
}

