/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition.processing;

import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.document.CollectionDataType;
import com.yahoo.document.TensorDataType;
import com.yahoo.searchdefinition.RankProfileRegistry;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.document.Attribute;
import com.yahoo.searchdefinition.document.SDField;
import com.yahoo.searchdefinition.processing.Processor;
import com.yahoo.vespa.model.container.search.QueryProfiles;

public class TensorFieldProcessor
extends Processor {
    public TensorFieldProcessor(Search search, DeployLogger deployLogger, RankProfileRegistry rankProfileRegistry, QueryProfiles queryProfiles) {
        super(search, deployLogger, rankProfileRegistry, queryProfiles);
    }

    @Override
    public void process() {
        for (SDField field : this.search.allConcreteFields()) {
            if (field.getDataType() instanceof TensorDataType) {
                this.warnUseOfTensorFieldAsAttribute(field);
                this.validateIndexingScripsForTensorField(field);
                this.validateAttributeSettingForTensorField(field);
                continue;
            }
            if (!(field.getDataType() instanceof CollectionDataType)) continue;
            this.validateDataTypeForCollectionField(field);
        }
    }

    private void warnUseOfTensorFieldAsAttribute(SDField field) {
        if (field.doesAttributing()) {
            this.warn(this.search, field, "An attribute of type 'tensor' is currently beta, and re-feeding data between Vespa versions might be required.");
        }
    }

    private void validateIndexingScripsForTensorField(SDField field) {
        if (field.doesIndexing()) {
            this.fail(this.search, field, "A field of type 'tensor' cannot be specified as an 'index' field.");
        }
    }

    private void validateAttributeSettingForTensorField(SDField field) {
        Attribute attribute;
        if (field.doesAttributing() && (attribute = field.getAttributes().get(field.getName())) != null && attribute.isFastSearch()) {
            this.fail(this.search, field, "An attribute of type 'tensor' cannot be 'fast-search'.");
        }
    }

    private void validateDataTypeForCollectionField(SDField field) {
        if (((CollectionDataType)field.getDataType()).getNestedType() instanceof TensorDataType) {
            this.fail(this.search, field, "A field with collection type of tensor is not supported. Use simple type 'tensor' instead.");
        }
    }
}

