/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.searchdefinition.DefaultRankProfile;
import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchdefinition.Search;
import com.yahoo.searchdefinition.UnrankedRankProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class RankProfileRegistry {
    private final Map<RankProfile, Search> rankProfileToSearch = new LinkedHashMap<RankProfile, Search>();
    private final Map<Search, Map<String, RankProfile>> rankProfiles = new LinkedHashMap<Search, Map<String, RankProfile>>();
    static final Set<String> overridableRankProfileNames = new HashSet<String>(Arrays.asList("default", "unranked"));

    public static RankProfileRegistry createRankProfileRegistryWithBuiltinRankProfiles(Search search) {
        RankProfileRegistry rankProfileRegistry = new RankProfileRegistry();
        rankProfileRegistry.addRankProfile(new DefaultRankProfile(search, rankProfileRegistry));
        rankProfileRegistry.addRankProfile(new UnrankedRankProfile(search, rankProfileRegistry));
        return rankProfileRegistry;
    }

    public void addRankProfile(RankProfile rankProfile) {
        if (!this.rankProfiles.containsKey(rankProfile.getSearch())) {
            this.rankProfiles.put(rankProfile.getSearch(), new LinkedHashMap());
        }
        this.checkForDuplicateRankProfile(rankProfile);
        this.rankProfiles.get(rankProfile.getSearch()).put(rankProfile.getName(), rankProfile);
        this.rankProfileToSearch.put(rankProfile, rankProfile.getSearch());
    }

    private void checkForDuplicateRankProfile(RankProfile rankProfile) {
        String rankProfileName = rankProfile.getName();
        RankProfile existingRangProfileWithSameName = this.rankProfiles.get(rankProfile.getSearch()).get(rankProfileName);
        if (existingRangProfileWithSameName == null) {
            return;
        }
        if (!overridableRankProfileNames.contains(rankProfileName)) {
            throw new IllegalArgumentException("Cannot add rank profile '" + rankProfileName + "' in search definition '" + rankProfile.getSearch().getName() + "', since it already exists");
        }
    }

    public RankProfile getRankProfile(Search search, String name) {
        return this.rankProfiles.get(search).get(name);
    }

    public Set<RankProfile> allRankProfiles() {
        return this.rankProfileToSearch.keySet();
    }

    public Collection<RankProfile> localRankProfiles(Search search) {
        Map<String, RankProfile> mapping = this.rankProfiles.get(search);
        if (mapping == null) {
            return Collections.emptyList();
        }
        return mapping.values();
    }
}

