/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchdefinition;

import com.yahoo.searchdefinition.RankProfile;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.FunctionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import java.util.Map;

class MacroShadower
extends ExpressionTransformer {
    private final Map<String, RankProfile.Macro> macros;

    public MacroShadower(Map<String, RankProfile.Macro> macros) {
        this.macros = macros;
    }

    public RankingExpression transform(RankingExpression expression) {
        String name = expression.getName();
        ExpressionNode node = expression.getRoot();
        ExpressionNode result = this.transform(node);
        return new RankingExpression(name, result);
    }

    public ExpressionNode transform(ExpressionNode node) {
        if (node instanceof FunctionNode) {
            return this.transformFunctionNode((FunctionNode)node);
        }
        if (node instanceof CompositeNode) {
            return this.transformChildren((CompositeNode)node);
        }
        return node;
    }

    protected ExpressionNode transformFunctionNode(FunctionNode function) {
        int macroArity;
        String name = function.getFunction().toString();
        RankProfile.Macro macro = this.macros.get(name);
        if (macro == null) {
            return this.transformChildren((CompositeNode)function);
        }
        int functionArity = function.getFunction().arity();
        int n = macroArity = macro.getFormalParams() != null ? macro.getFormalParams().size() : 0;
        if (functionArity != macroArity) {
            return this.transformChildren((CompositeNode)function);
        }
        ReferenceNode node = new ReferenceNode(name, function.children(), null);
        return this.transformChildren((CompositeNode)node);
    }
}

