/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.collections.Comparables;
import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.Endpoint;
import com.yahoo.config.application.api.TimeWindow;
import com.yahoo.config.application.api.xml.DeploymentSpecXmlReader;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.Tags;
import com.yahoo.config.provision.Zone;
import com.yahoo.config.provision.ZoneEndpoint;
import com.yahoo.config.provision.zone.ZoneId;
import java.io.Reader;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DeploymentSpec {
    public static final DeploymentSpec empty = new DeploymentSpec(List.of(), Optional.empty(), Optional.empty(), Optional.empty(), Map.of(), Optional.empty(), List.of(), "<deployment version='1.0'/>", List.of(), DevSpec.empty);
    private final List<Step> steps;
    private final Optional<Integer> majorVersion;
    private final Optional<AthenzDomain> athenzDomain;
    private final Optional<AthenzService> athenzService;
    private final Map<CloudName, CloudAccount> cloudAccounts;
    private final Optional<Duration> hostTTL;
    private final List<Endpoint> endpoints;
    private final List<DeprecatedElement> deprecatedElements;
    private final DevSpec devSpec;
    private final String xmlForm;

    public DeploymentSpec(List<Step> steps, Optional<Integer> majorVersion, Optional<AthenzDomain> athenzDomain, Optional<AthenzService> athenzService, Map<CloudName, CloudAccount> cloudAccounts, Optional<Duration> hostTTL, List<Endpoint> endpoints, String xmlForm, List<DeprecatedElement> deprecatedElements, DevSpec devSpec) {
        this.steps = List.copyOf((Collection)Objects.requireNonNull(steps));
        this.majorVersion = Objects.requireNonNull(majorVersion);
        this.athenzDomain = Objects.requireNonNull(athenzDomain);
        this.athenzService = Objects.requireNonNull(athenzService);
        this.cloudAccounts = Map.copyOf(cloudAccounts);
        this.hostTTL = Objects.requireNonNull(hostTTL);
        this.xmlForm = Objects.requireNonNull(xmlForm);
        this.endpoints = List.copyOf((Collection)Objects.requireNonNull(endpoints));
        this.deprecatedElements = List.copyOf((Collection)Objects.requireNonNull(deprecatedElements));
        this.devSpec = Objects.requireNonNull(devSpec);
        this.validateTotalDelay(steps);
        this.validateUpgradePoliciesOfIncreasingConservativeness(steps);
        this.validateAthenz();
        this.validateApplicationEndpoints();
        hostTTL.filter(Duration::isNegative).ifPresent(ttl -> DeploymentSpec.illegal("Host TTL cannot be negative"));
    }

    public boolean isEmpty() {
        return this == empty;
    }

    private void validateTotalDelay(List<Step> steps) {
        long totalDelaySeconds = steps.stream().mapToLong(step -> step.delay().getSeconds()).sum();
        if (totalDelaySeconds > Duration.ofHours(48L).getSeconds()) {
            DeploymentSpec.illegal("The total delay specified is " + String.valueOf(Duration.ofSeconds(totalDelaySeconds)) + " but max 48 hours is allowed");
        }
    }

    private void validateUpgradePoliciesOfIncreasingConservativeness(List<Step> steps) {
        UpgradePolicy previous = Collections.min(List.of(UpgradePolicy.values()));
        for (Step step : steps) {
            UpgradePolicy strictest = previous;
            List<DeploymentInstanceSpec> specs = DeploymentSpec.instances(List.of(step));
            for (DeploymentInstanceSpec spec : specs) {
                if (spec.upgradePolicy().compareTo(previous) < 0) {
                    DeploymentSpec.illegal("Instance '" + String.valueOf(spec.name()) + "' cannot have a looser upgrade policy than the previous of '" + String.valueOf((Object)previous) + "'");
                }
                strictest = (UpgradePolicy)((Object)Comparables.max((Comparable)((Object)strictest), (Comparable)((Object)spec.upgradePolicy())));
            }
            previous = strictest;
        }
    }

    private void validateAthenz() {
        block5: {
            block4: {
                if (!this.athenzDomain.isEmpty()) break block4;
                for (DeploymentInstanceSpec instance : this.instances()) {
                    for (DeclaredZone zone : instance.zones()) {
                        if (!zone.athenzService().isPresent()) continue;
                        DeploymentSpec.illegal("Athenz service configured for zone: " + String.valueOf(zone) + ", but Athenz domain is not configured");
                    }
                }
                break block5;
            }
            if (!this.athenzService.isEmpty()) break block5;
            for (DeploymentInstanceSpec instance : this.instances()) {
                for (DeclaredZone zone : instance.zones()) {
                    if (!zone.athenzService().isEmpty()) continue;
                    DeploymentSpec.illegal("Athenz domain is configured, but Athenz service not configured for zone: " + String.valueOf(zone));
                }
            }
        }
    }

    private void validateApplicationEndpoints() {
        for (Endpoint endpoint : this.endpoints) {
            if (endpoint.level() != Endpoint.Level.application) {
                DeploymentSpec.illegal("Endpoint '" + endpoint.endpointId() + "' must be an application\u2013level endpoint, got " + String.valueOf((Object)endpoint.level()));
            }
            String prefix = "Application-level endpoint '" + endpoint.endpointId() + "': ";
            for (Endpoint.Target target : endpoint.targets()) {
                Optional<DeploymentInstanceSpec> instance = this.instance(target.instance());
                if (instance.isEmpty()) {
                    DeploymentSpec.illegal(prefix + "targets undeclared instance '" + String.valueOf(target.instance()) + "'");
                }
                if (!instance.get().deploysTo(Environment.prod, target.region())) {
                    DeploymentSpec.illegal(prefix + "targets undeclared region '" + String.valueOf(target.region()) + "' in instance '" + String.valueOf(target.instance()) + "'");
                }
                if (!instance.get().zoneEndpoint(ZoneId.from((Environment)Environment.prod, (RegionName)target.region()), ClusterSpec.Id.from((String)endpoint.containerId())).map(zoneEndpoint -> !zoneEndpoint.isPublicEndpoint()).orElse(false).booleanValue()) continue;
                DeploymentSpec.illegal(prefix + "targets '" + target.region().value() + "' in '" + target.instance().value() + "', but its zone endpoint has 'enabled' set to 'false'");
            }
        }
    }

    public Optional<Integer> majorVersion() {
        return this.majorVersion;
    }

    public List<Step> steps() {
        return this.steps;
    }

    public Optional<AthenzDomain> athenzDomain() {
        return this.athenzDomain;
    }

    public Optional<AthenzService> athenzService() {
        return this.athenzService;
    }

    public Optional<AthenzService> athenzService(InstanceName instance, Environment environment, RegionName region) {
        return (environment.isManuallyDeployed() ? this.devSpec.athenzService : this.instance(instance).flatMap(spec -> spec.athenzService(environment, region))).or(this::athenzService);
    }

    public CloudAccount cloudAccount(CloudName cloud, InstanceName instance, ZoneId zone) {
        return (zone.environment().isManuallyDeployed() ? this.devSpec.cloudAccounts : this.instance(instance).map(spec -> spec.cloudAccounts(zone.environment(), zone.region()))).orElse(this.cloudAccounts).getOrDefault(cloud, CloudAccount.empty);
    }

    public Map<CloudName, CloudAccount> cloudAccounts() {
        return this.cloudAccounts;
    }

    public Tags tags(InstanceName instance, Environment environment) {
        return environment.isManuallyDeployed() ? this.devSpec.tags : this.instance(instance).map(DeploymentInstanceSpec::tags).orElse(Tags.empty());
    }

    public Optional<Duration> hostTTL(InstanceName instance, Environment environment, RegionName region) {
        return (environment.isManuallyDeployed() ? this.devSpec.hostTTL : this.instance(instance).flatMap(spec -> spec.hostTTL(environment, Optional.of(region)))).or(this::hostTTL);
    }

    Optional<Duration> hostTTL() {
        return this.hostTTL;
    }

    public ZoneEndpoint zoneEndpoint(InstanceName instance, Zone zone, ClusterSpec.Id cluster, boolean useNonPublicEndpointForTest) {
        if (zone.environment().isTest() && (useNonPublicEndpointForTest || this.instances().stream().anyMatch(spec -> spec.zoneEndpoints().getOrDefault(cluster, Map.of()).values().stream().anyMatch(endpoint -> !endpoint.isPublicEndpoint()))) && zone.cloud().supportsPrivateEndpoints()) {
            return ZoneEndpoint.privateEndpoint;
        }
        if (zone.environment().isManuallyDeployed()) {
            return this.devSpec.zoneEndpoints.getOrDefault(cluster, ZoneEndpoint.defaultEndpoint);
        }
        return this.instance(instance).flatMap(spec -> spec.zoneEndpoint(zone.id(), cluster)).orElse(ZoneEndpoint.defaultEndpoint);
    }

    public ZoneEndpoint zoneEndpoint(InstanceName instance, ZoneId zone, ClusterSpec.Id cluster, boolean useNonPublicEndpointForTest) {
        if (zone.environment().isTest() && (useNonPublicEndpointForTest || this.instances().stream().anyMatch(spec -> spec.zoneEndpoints().getOrDefault(cluster, Map.of()).values().stream().anyMatch(endpoint -> !endpoint.isPublicEndpoint()))) && !zone.region().value().startsWith(CloudName.AZURE.value() + "-")) {
            return ZoneEndpoint.privateEndpoint;
        }
        if (zone.environment().isManuallyDeployed()) {
            return this.devSpec.zoneEndpoints.getOrDefault(cluster, ZoneEndpoint.defaultEndpoint);
        }
        return this.instance(instance).flatMap(spec -> spec.zoneEndpoint(zone, cluster)).orElse(ZoneEndpoint.defaultEndpoint);
    }

    public String xmlForm() {
        return this.xmlForm;
    }

    public Optional<DeploymentInstanceSpec> instance(InstanceName name) {
        for (DeploymentInstanceSpec instance : this.instances()) {
            if (!instance.name().equals((Object)name)) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public DeploymentInstanceSpec requireInstance(String name) {
        return this.requireInstance(InstanceName.from((String)name));
    }

    public DeploymentInstanceSpec requireInstance(InstanceName name) {
        Optional<DeploymentInstanceSpec> instance = this.instance(name);
        if (instance.isEmpty()) {
            throw new IllegalArgumentException("No instance '" + String.valueOf(name) + "' in deployment.xml. Instances: " + this.instances().stream().map(spec -> spec.name().toString()).collect(Collectors.joining(",")));
        }
        return instance.get();
    }

    public List<InstanceName> instanceNames() {
        return this.instances().stream().map(DeploymentInstanceSpec::name).toList();
    }

    public List<DeploymentInstanceSpec> instances() {
        return DeploymentSpec.instances(this.steps);
    }

    public List<Endpoint> endpoints() {
        return this.endpoints;
    }

    public List<DeprecatedElement> deprecatedElements() {
        return this.deprecatedElements;
    }

    private static List<DeploymentInstanceSpec> instances(List<Step> steps) {
        return steps.stream().flatMap(DeploymentSpec::flatten).toList();
    }

    private static Stream<DeploymentInstanceSpec> flatten(Step step) {
        if (step instanceof DeploymentInstanceSpec) {
            return Stream.of((DeploymentInstanceSpec)step);
        }
        return step.steps().stream().flatMap(DeploymentSpec::flatten);
    }

    static void illegal(String message) {
        throw new IllegalArgumentException(message);
    }

    public static DeploymentSpec fromXml(Reader reader) {
        return new DeploymentSpecXmlReader().read(reader);
    }

    public static DeploymentSpec fromXml(String xmlForm) {
        return DeploymentSpec.fromXml(xmlForm, true);
    }

    public static DeploymentSpec fromXml(String xmlForm, boolean validate) {
        return new DeploymentSpecXmlReader(validate).read(xmlForm);
    }

    public static String toMessageString(Throwable t) {
        StringBuilder b = new StringBuilder();
        String lastMessage = null;
        while (t != null) {
            String message = t.getMessage();
            if (message != null && !message.equals(lastMessage)) {
                if (!b.isEmpty()) {
                    b.append(": ");
                }
                b.append(message);
                lastMessage = message;
            }
            t = t.getCause();
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentSpec other = (DeploymentSpec)o;
        return this.majorVersion.equals(other.majorVersion) && this.steps.equals(other.steps) && this.xmlForm.equals(other.xmlForm);
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.steps, this.xmlForm);
    }

    public int deployableHashCode() {
        Object[] toHash = new Object[this.instances().size() + 5];
        int i = 0;
        toHash[i++] = this.majorVersion;
        toHash[i++] = this.athenzDomain;
        toHash[i++] = this.athenzService;
        toHash[i++] = this.endpoints;
        toHash[i++] = this.cloudAccounts;
        for (DeploymentInstanceSpec instance : this.instances()) {
            toHash[i++] = instance.deployableHashCode();
        }
        return Arrays.hashCode(toHash);
    }

    public static class DevSpec {
        public static final DevSpec empty = new DevSpec(Optional.empty(), Optional.empty(), Optional.empty(), Tags.empty(), Map.of());
        private final Optional<AthenzService> athenzService;
        private final Optional<Map<CloudName, CloudAccount>> cloudAccounts;
        private final Optional<Duration> hostTTL;
        private final Tags tags;
        private final Map<ClusterSpec.Id, ZoneEndpoint> zoneEndpoints;

        public DevSpec(Optional<AthenzService> athenzService, Optional<Map<CloudName, CloudAccount>> cloudAccounts, Optional<Duration> hostTTL, Tags tags, Map<ClusterSpec.Id, ZoneEndpoint> zoneEndpoints) {
            this.athenzService = Objects.requireNonNull(athenzService);
            this.cloudAccounts = cloudAccounts.map(Map::copyOf);
            this.hostTTL = Objects.requireNonNull(hostTTL);
            this.tags = Objects.requireNonNull(tags);
            this.zoneEndpoints = Map.copyOf(zoneEndpoints);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DevSpec devSpec = (DevSpec)o;
            return Objects.equals(this.athenzService, devSpec.athenzService) && Objects.equals(this.cloudAccounts, devSpec.cloudAccounts) && Objects.equals(this.hostTTL, devSpec.hostTTL) && Objects.equals(this.tags, devSpec.tags) && Objects.equals(this.zoneEndpoints, devSpec.zoneEndpoints);
        }

        public int hashCode() {
            return Objects.hash(this.athenzService, this.cloudAccounts, this.hostTTL, this.tags, this.zoneEndpoints);
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", "dev settings: ", "").setEmptyValue("no dev settings");
            this.athenzService.ifPresent(service -> joiner.add("athenz-service: " + service.value()));
            this.cloudAccounts.ifPresent(cas -> joiner.add(cas.entrySet().stream().map(ca -> String.valueOf(ca.getKey()) + ": " + String.valueOf(ca.getValue())).collect(Collectors.joining(", ", "cloud accounts: ", ""))));
            this.hostTTL.ifPresent(ttl -> joiner.add("host-ttl: " + String.valueOf(ttl)));
            if (!this.tags.isEmpty()) {
                joiner.add("tags: " + String.valueOf(this.tags));
            }
            if (!this.zoneEndpoints.isEmpty()) {
                joiner.add("endpoint settings for clusters: " + this.zoneEndpoints.keySet().stream().map(ClusterSpec.Id::value).collect(Collectors.joining(", ")));
            }
            return joiner.toString();
        }
    }

    public static enum UpgradePolicy {
        canary,
        defaultPolicy,
        conservative;

    }

    public static abstract class Step {
        public final boolean concerns(Environment environment) {
            return this.concerns(environment, Optional.empty());
        }

        public abstract boolean concerns(Environment var1, Optional<RegionName> var2);

        public List<DeclaredZone> zones() {
            return List.of();
        }

        public Duration delay() {
            return Duration.ZERO;
        }

        public List<Step> steps() {
            return List.of();
        }

        public boolean isTest() {
            return false;
        }

        public boolean isOrdered() {
            return true;
        }

        public Optional<Duration> hostTTL() {
            return Optional.empty();
        }
    }

    public static class DeclaredZone
    extends Step {
        private final Environment environment;
        private final Optional<RegionName> region;
        private final Optional<AthenzService> athenzService;
        private final Optional<String> testerNodes;
        private final Map<CloudName, CloudAccount> cloudAccounts;
        private final Optional<Duration> hostTTL;

        public DeclaredZone(Environment environment) {
            this(environment, Optional.empty(), Optional.empty(), Optional.empty(), Map.of(), Optional.empty());
        }

        public DeclaredZone(Environment environment, Optional<RegionName> region, Optional<AthenzService> athenzService, Optional<String> testerNodes, Map<CloudName, CloudAccount> cloudAccounts, Optional<Duration> hostTTL) {
            if (environment != Environment.prod && region.isPresent()) {
                DeploymentSpec.illegal("Non-prod environments cannot specify a region");
            }
            if (environment == Environment.prod && region.isEmpty()) {
                DeploymentSpec.illegal("Prod environments must be specified with a region");
            }
            hostTTL.filter(Duration::isNegative).ifPresent(ttl -> DeploymentSpec.illegal("Host TTL cannot be negative"));
            this.environment = Objects.requireNonNull(environment);
            this.region = Objects.requireNonNull(region);
            this.athenzService = Objects.requireNonNull(athenzService);
            this.testerNodes = Objects.requireNonNull(testerNodes);
            this.cloudAccounts = Map.copyOf(cloudAccounts);
            this.hostTTL = Objects.requireNonNull(hostTTL);
        }

        public Environment environment() {
            return this.environment;
        }

        public Optional<RegionName> region() {
            return this.region;
        }

        public Optional<String> testerNodes() {
            return this.testerNodes;
        }

        Optional<AthenzService> athenzService() {
            return this.athenzService;
        }

        Map<CloudName, CloudAccount> cloudAccounts() {
            return this.cloudAccounts;
        }

        @Override
        public List<DeclaredZone> zones() {
            return List.of(this);
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            if (environment != this.environment) {
                return false;
            }
            return !region.isPresent() || !this.region.isPresent() || region.equals(this.region);
        }

        @Override
        public boolean isTest() {
            return this.environment.isTest();
        }

        public int hashCode() {
            return Objects.hash(this.environment, this.region);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeclaredZone)) {
                return false;
            }
            DeclaredZone other = (DeclaredZone)o;
            if (this.environment != other.environment) {
                return false;
            }
            return this.region.equals(other.region());
        }

        public String toString() {
            return String.valueOf(this.environment) + this.region.map(regionName -> "." + String.valueOf(regionName)).orElse("");
        }

        @Override
        public Optional<Duration> hostTTL() {
            return this.hostTTL;
        }
    }

    public static class DeprecatedElement {
        private final String tagName;
        private final List<String> attributes;
        private final String message;
        private final int majorVersion;

        public DeprecatedElement(int majorVersion, String tagName, List<String> attributes, String message) {
            this.tagName = Objects.requireNonNull(tagName);
            this.attributes = Objects.requireNonNull(attributes);
            this.message = Objects.requireNonNull(message);
            this.majorVersion = majorVersion;
            if (message.isBlank()) {
                throw new IllegalArgumentException("message must be non-empty");
            }
        }

        public int majorVersion() {
            return this.majorVersion;
        }

        public String humanReadableString() {
            String deprecationDescription = "deprecated since major version " + this.majorVersion;
            if (this.attributes.isEmpty()) {
                return "Element '" + this.tagName + "' is " + deprecationDescription + ". " + this.message;
            }
            return "Element '" + this.tagName + "' contains attribute" + (this.attributes.size() > 1 ? "s " : " ") + this.attributes.stream().map(attr -> "'" + attr + "'").collect(Collectors.joining(", ")) + " " + deprecationDescription + ". " + this.message;
        }

        public String toString() {
            return this.humanReadableString();
        }
    }

    public static class ChangeBlocker {
        private final boolean revision;
        private final boolean version;
        private final TimeWindow window;

        public ChangeBlocker(boolean revision, boolean version, TimeWindow window) {
            this.revision = revision;
            this.version = version;
            this.window = window;
        }

        public boolean blocksRevisions() {
            return this.revision;
        }

        public boolean blocksVersions() {
            return this.version;
        }

        public TimeWindow window() {
            return this.window;
        }

        public String toString() {
            return "change blocker revision=" + this.revision + " version=" + this.version + " window=" + String.valueOf(this.window);
        }
    }

    public static enum UpgradeRollout {
        separate,
        leading,
        simultaneous;

    }

    public static enum RevisionChange {
        whenClear,
        whenFailing,
        always;

    }

    public static enum RevisionTarget {
        next,
        latest;

    }

    public static class ParallelSteps
    extends Steps {
        public ParallelSteps(List<Step> steps) {
            super(steps);
        }

        @Override
        public Duration delay() {
            return this.steps().stream().map(Step::delay).max(Comparator.naturalOrder()).orElse(Duration.ZERO);
        }

        @Override
        public boolean isOrdered() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParallelSteps)) {
                return false;
            }
            return Objects.equals(this.steps(), ((ParallelSteps)o).steps());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.steps());
        }

        @Override
        public String toString() {
            return this.steps().size() + " parallel steps";
        }
    }

    public static class Steps
    extends Step {
        private final List<Step> steps;

        public Steps(List<Step> steps) {
            this.steps = List.copyOf(steps);
        }

        @Override
        public List<DeclaredZone> zones() {
            return this.steps.stream().flatMap(step -> step.zones().stream()).toList();
        }

        @Override
        public List<Step> steps() {
            return this.steps;
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            return this.steps.stream().anyMatch(step -> step.concerns(environment, region));
        }

        @Override
        public Duration delay() {
            return this.steps.stream().map(Step::delay).reduce(Duration.ZERO, Duration::plus);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.steps.equals(((Steps)o).steps);
        }

        public int hashCode() {
            return Objects.hash(this.steps);
        }

        public String toString() {
            return this.steps.size() + " steps";
        }
    }

    public static class DeclaredTest
    extends Step {
        private final RegionName region;
        private final Optional<Duration> hostTTL;

        public DeclaredTest(RegionName region, Optional<Duration> hostTTL) {
            this.region = Objects.requireNonNull(region);
            this.hostTTL = Objects.requireNonNull(hostTTL);
            hostTTL.filter(Duration::isNegative).ifPresent(ttl -> DeploymentSpec.illegal("Host TTL cannot be negative"));
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            return region.map(arg_0 -> ((RegionName)this.region).equals(arg_0)).orElse(true) != false && environment == Environment.prod;
        }

        @Override
        public boolean isTest() {
            return true;
        }

        public RegionName region() {
            return this.region;
        }

        @Override
        public Optional<Duration> hostTTL() {
            return this.hostTTL;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeclaredTest that = (DeclaredTest)o;
            return this.region.equals((Object)that.region);
        }

        public int hashCode() {
            return Objects.hash(this.region);
        }

        public String toString() {
            return "tests for prod." + String.valueOf(this.region);
        }
    }

    public static class Delay
    extends Step {
        private final Duration duration;

        public Delay(Duration duration) {
            this.duration = duration;
        }

        @Override
        public Duration delay() {
            return this.duration;
        }

        @Override
        public boolean concerns(Environment environment, Optional<RegionName> region) {
            return false;
        }

        public String toString() {
            return "delay " + String.valueOf(this.duration);
        }
    }
}

