/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.OnnxModelCost;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.model.api.TenantSecretStore;
import com.yahoo.config.model.api.TenantVault;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DataplaneToken;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.SharedHosts;
import com.yahoo.config.provision.Zone;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public interface ModelContext {
    public ApplicationPackage applicationPackage();

    public Optional<Model> previousModel();

    public HostProvisioner getHostProvisioner();

    public Provisioned provisioned();

    public DeployLogger deployLogger();

    public ConfigDefinitionRepo configDefinitionRepo();

    public FileRegistry getFileRegistry();

    public ExecutorService getExecutor();

    default public Optional<? extends Reindexing> reindexing() {
        return Optional.empty();
    }

    public Properties properties();

    default public Optional<File> appDir() {
        return Optional.empty();
    }

    public OnnxModelCost onnxModelCost();

    default public Optional<DockerImage> wantedDockerImageRepo() {
        return Optional.empty();
    }

    public Version modelVespaVersion();

    public Version wantedNodeVespaVersion();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ModelFeatureFlag {
        public String[] owners();

        public String removeAfter() default "";

        public String comment() default "";
    }

    public static interface Properties {
        public FeatureFlags featureFlags();

        public boolean multitenant();

        public ApplicationId applicationId();

        public List<ConfigServerSpec> configServerSpecs();

        public HostName loadBalancerName();

        public URI ztsUrl();

        public AthenzDomain tenantSecretDomain();

        public String athenzDnsSuffix();

        public boolean hostedVespa();

        public Zone zone();

        public Set<ContainerEndpoint> endpoints();

        public boolean isBootstrap();

        public boolean isFirstTimeDeployment();

        default public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return Optional.empty();
        }

        default public Optional<AthenzDomain> athenzDomain() {
            return Optional.empty();
        }

        default public Quota quota() {
            return Quota.unlimited();
        }

        default public List<TenantVault> tenantVaults() {
            return List.of();
        }

        default public List<TenantSecretStore> tenantSecretStores() {
            return List.of();
        }

        default public String jvmGCOptions() {
            return this.jvmGCOptions(Optional.empty());
        }

        public String jvmGCOptions(Optional<ClusterSpec.Type> var1);

        default public boolean useDedicatedNodeForLogserver() {
            return true;
        }

        default public boolean allowDisableMtls() {
            return true;
        }

        default public List<X509Certificate> operatorCertificates() {
            return List.of();
        }

        default public List<String> tlsCiphersOverride() {
            return List.of();
        }

        public List<String> environmentVariables();

        default public Optional<CloudAccount> cloudAccount() {
            return Optional.empty();
        }

        default public boolean allowUserFilters() {
            return true;
        }

        default public Duration endpointConnectionTtl() {
            return Duration.ZERO;
        }

        default public List<DataplaneToken> dataplaneTokens() {
            return List.of();
        }

        default public List<String> requestPrefixForLoggingContent() {
            return List.of();
        }

        default public List<String> jdiscHttpComplianceViolations() {
            return List.of();
        }
    }

    public static interface FeatureFlags {
        @ModelFeatureFlag(owners={"hakonhall"})
        default public boolean useNonPublicEndpointForTest() {
            return false;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public String responseSequencerType() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public double queryDispatchWarmup() {
            return 5.0;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public int defaultNumResponseThreads() {
            return 2;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public int mbusNetworkThreads() {
            return 1;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public int mbusJavaRpcNumTargets() {
            return 2;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public int mbusJavaEventsBeforeWakeup() {
            return 1;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public int mbusCppRpcNumTargets() {
            return 2;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public int mbusCppEventsBeforeWakeup() {
            return 1;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public int rpcNumTargets() {
            return 2;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public int rpcEventsBeforeWakeup() {
            return 1;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public boolean useAsyncMessageHandlingOnSchedule() {
            return true;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public double feedConcurrency() {
            return 0.5;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public double feedNiceness() {
            return 0.0;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public int maxUnCommittedMemory() {
            return 130000;
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public String searchMmapAdvise() {
            return "SEQUENTIAL";
        }

        @ModelFeatureFlag(owners={"bjorncs"})
        default public boolean containerDumpHeapOnShutdownTimeout() {
            return false;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public int heapSizePercentage() {
            return 0;
        }

        @ModelFeatureFlag(owners={"bjorncs", "tokle"})
        default public List<String> allowedAthenzProxyIdentities() {
            return List.of();
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public int maxActivationInhibitedOutOfSyncGroups() {
            return 0;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public double resourceLimitDisk() {
            return 0.75;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public double resourceLimitMemory() {
            return 0.8;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public double resourceLimitLowWatermarkDifference() {
            return 0.0;
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public double minNodeRatioPerGroup() {
            return 0.0;
        }

        @ModelFeatureFlag(owners={"arnej"})
        default public boolean forwardIssuesAsErrors() {
            return true;
        }

        @ModelFeatureFlag(owners={"arnej"})
        default public boolean useV8GeoPositions() {
            return false;
        }

        @ModelFeatureFlag(owners={"arnej", "andreer"})
        default public List<String> ignoredHttpUserAgents() {
            return List.of();
        }

        @ModelFeatureFlag(owners={"arnej"})
        default public String logFileCompressionAlgorithm(String defVal) {
            return defVal;
        }

        @ModelFeatureFlag(owners={"hmusum"}, comment="Select summary decode type")
        default public String summaryDecodePolicy() {
            return "eager";
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public int contentLayerMetadataFeatureLevel() {
            return 0;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public String unknownConfigDefinition() {
            return "warn";
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public int searchHandlerThreadpool() {
            return 2;
        }

        @ModelFeatureFlag(owners={"havardpe"})
        default public boolean sortBlueprintsByCost() {
            return false;
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public int persistenceThreadMaxFeedOpBatchSize() {
            return 1;
        }

        @ModelFeatureFlag(owners={"olaa"})
        default public boolean logserverOtelCol() {
            return false;
        }

        @ModelFeatureFlag(owners={"bratseth"})
        default public SharedHosts sharedHosts() {
            return SharedHosts.empty();
        }

        @ModelFeatureFlag(owners={"bratseth"})
        default public NodeResources.Architecture adminClusterArchitecture() {
            return NodeResources.Architecture.x86_64;
        }

        @ModelFeatureFlag(owners={"arnej"})
        default public double logserverNodeMemory() {
            return 0.0;
        }

        @ModelFeatureFlag(owners={"arnej"})
        default public double clusterControllerNodeMemory() {
            return 0.0;
        }

        @ModelFeatureFlag(owners={"vekterli"}, removeAfter="8.505")
        default public boolean symmetricPutAndActivateReplicaSelection() {
            return true;
        }

        @ModelFeatureFlag(owners={"arnej"})
        default public boolean useLegacyWandQueryParsing() {
            return true;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public boolean forwardAllLogLevels() {
            return true;
        }

        @ModelFeatureFlag(owners={"hmusum"})
        default public long zookeeperPreAllocSize() {
            return 65536L;
        }

        @ModelFeatureFlag(owners={"bjorncs"})
        default public int documentV1QueueSize() {
            return -1;
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public int maxContentNodeMaintenanceOpConcurrency() {
            return -1;
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public int maxDistributorDocumentOperationSizeMib() {
            return -1;
        }
    }
}

