/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.path.Path;
import java.io.IOException;
import java.util.Optional;

public record OnnxMemoryStats(long vmSize, long vmRss, long mallocPeak, long mallocCurrent) {
    private static final String VM_SIZE_FIELD = "vm_size";
    private static final String VM_RSS_FIELD = "vm_rss";
    private static final String MALLOC_PEAK_FIELD = "malloc_peak";
    private static final String MALLOC_CURRENT_FIELD = "malloc_current";
    private static final ObjectMapper jsonParser = new ObjectMapper();

    public static OnnxMemoryStats fromJson(JsonNode json) {
        return new OnnxMemoryStats(json.get(VM_SIZE_FIELD).asLong(), json.get(VM_RSS_FIELD).asLong(), Optional.ofNullable(json.get(MALLOC_PEAK_FIELD)).map(JsonNode::asLong).orElse(0L), Optional.ofNullable(json.get(MALLOC_CURRENT_FIELD)).map(JsonNode::asLong).orElse(0L));
    }

    public static OnnxMemoryStats fromJson(ApplicationFile file) throws IOException {
        return OnnxMemoryStats.fromJson(jsonParser.readTree(file.createReader()));
    }

    public static Path memoryStatsFilePath(Path modelPath) {
        String fileName = modelPath.getRelative().replaceAll("[^\\w$@_]", "_") + ".memory_stats";
        return ApplicationPackage.MODELS_GENERATED_REPLICATED_DIR.append(fileName);
    }

    public long peakMemoryUsage() {
        return Long.max(this.vmSize, Long.max(this.vmRss, Long.max(this.mallocPeak, this.mallocCurrent)));
    }

    public JsonNode toJson() {
        return jsonParser.createObjectNode().put(VM_SIZE_FIELD, this.vmSize).put(VM_RSS_FIELD, this.vmRss).put(MALLOC_PEAK_FIELD, this.mallocPeak).put(MALLOC_CURRENT_FIELD, this.mallocCurrent);
    }
}

