/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Notifications {
    private static final Notifications none = new Notifications(Collections.emptyMap(), Collections.emptyMap());
    private final Map<When, List<String>> emailAddresses;
    private final Map<When, List<Role>> emailRoles;

    public static Notifications none() {
        return none;
    }

    private Notifications(Map<When, List<String>> emailAddresses, Map<When, List<Role>> emailRoles) {
        this.emailAddresses = emailAddresses;
        this.emailRoles = emailRoles;
    }

    public static Notifications of(Map<When, List<String>> emailAddressesByWhen, Map<When, List<Role>> emailRolesByWhen) {
        if (emailAddressesByWhen.values().stream().allMatch(List::isEmpty) && emailRolesByWhen.values().stream().allMatch(List::isEmpty)) {
            return none;
        }
        ImmutableMap.Builder emailAddresses = ImmutableMap.builder();
        emailAddressesByWhen.forEach((when, addresses) -> emailAddresses.put((Object)when, List.copyOf(addresses)));
        ImmutableMap.Builder emailRoles = ImmutableMap.builder();
        emailRolesByWhen.forEach((when, roles) -> emailRoles.put((Object)when, List.copyOf(roles)));
        return new Notifications((Map<When, List<String>>)emailAddresses.build(), (Map<When, List<Role>>)emailRoles.build());
    }

    public Set<String> emailAddressesFor(When when) {
        ImmutableSet.Builder addresses = ImmutableSet.builder();
        addresses.addAll((Iterable)this.emailAddresses.getOrDefault((Object)when, Collections.emptyList()));
        for (When include : when.includes) {
            addresses.addAll(this.emailAddressesFor(include));
        }
        return addresses.build();
    }

    public Set<Role> emailRolesFor(When when) {
        ImmutableSet.Builder roles = ImmutableSet.builder();
        roles.addAll((Iterable)this.emailRoles.getOrDefault((Object)when, Collections.emptyList()));
        for (When include : when.includes) {
            roles.addAll(this.emailRolesFor(include));
        }
        return roles.build();
    }

    public static enum When {
        failing(new When[0]),
        failingCommit(failing);

        private final List<When> includes;

        private When(When ... includes) {
            this.includes = Arrays.asList(includes);
        }

        public static String toValue(When when) {
            switch (when) {
                case failing: {
                    return "failing";
                }
                case failingCommit: {
                    return "failing-commit";
                }
            }
            throw new IllegalArgumentException("Unexpected constant '" + when.name() + "'.");
        }

        public static When fromValue(String value) {
            return switch (value) {
                case "failing" -> failing;
                case "failing-commit" -> failingCommit;
                default -> throw new IllegalArgumentException("Unknown value '" + value + "'.");
            };
        }
    }

    public static enum Role {
        author;


        public static String toValue(Role role) {
            switch (role) {
                case author: {
                    return "author";
                }
            }
            throw new IllegalArgumentException("Unexpected constant '" + role.name() + "'.");
        }

        public static Role fromValue(String value) {
            switch (value) {
                case "author": {
                    return author;
                }
            }
            throw new IllegalArgumentException("Unknown value '" + value + "'.");
        }
    }
}

