/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.yahoo.config.application.api.ApplicationFile;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.model.api.OnnxModelOptions;
import com.yahoo.config.provision.ApplicationId;
import java.net.URI;
import java.util.Map;
import java.util.Optional;

public interface OnnxModelCost {
    public Calculator newCalculator(ApplicationPackage var1, ApplicationId var2);

    public static OnnxModelCost disabled() {
        return new DisabledOnnxModelCost();
    }

    public static class DisabledOnnxModelCost
    implements OnnxModelCost,
    Calculator {
        @Override
        public Calculator newCalculator(ApplicationPackage appPkg, ApplicationId applicationId) {
            return this;
        }

        @Override
        public long aggregatedModelCostInBytes() {
            return 0L;
        }

        @Override
        public void registerModel(ApplicationFile path, OnnxModelOptions onnxModelOptions) {
        }

        @Override
        public void registerModel(URI uri, OnnxModelOptions onnxModelOptions) {
        }

        @Override
        public Map<String, ModelInfo> models() {
            return Map.of();
        }

        @Override
        public void setRestartOnDeploy() {
        }

        @Override
        public boolean restartOnDeploy() {
            return false;
        }

        @Override
        public void store() {
        }
    }

    public record ModelInfo(String modelId, long estimatedCost, long hash, Optional<OnnxModelOptions> onnxModelOptions) {
        public ModelInfo(String modelId, long estimatedCost, long hash, OnnxModelOptions onnxModelOptions) {
            this(modelId, estimatedCost, hash, Optional.of(onnxModelOptions));
        }

        public OnnxModelOptions options() {
            return this.onnxModelOptions.orElseThrow(() -> new IllegalStateException("No onnxModelOptions exist"));
        }
    }

    public static interface Calculator {
        public long aggregatedModelCostInBytes();

        public void registerModel(ApplicationFile var1, OnnxModelOptions var2);

        public void registerModel(URI var1, OnnxModelOptions var2);

        public Map<String, ModelInfo> models();

        public void setRestartOnDeploy();

        public boolean restartOnDeploy();

        public void store();
    }
}

