/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.provision.RegionName;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Endpoint {
    private static final Pattern endpointPattern = Pattern.compile("^[a-z](?:-?[a-z0-9]+)*$");
    private static final int endpointMaxLength = 12;
    private static final String defaultEndpointId = "default";
    private final Optional<String> endpointId;
    private final String containerId;
    private final Set<RegionName> regions;

    public Endpoint(Optional<String> endpointId, String containerId, Set<String> regions) {
        this.endpointId = Objects.requireNonNull(endpointId, "endpointId must be non-null");
        this.containerId = Objects.requireNonNull(containerId, "containerId must be non-null");
        this.regions = Set.copyOf(Objects.requireNonNull(regions.stream().map(RegionName::from).collect(Collectors.toList()), "Missing 'regions' parameter"));
        if (this.endpointId().length() > 12 || !endpointPattern.matcher(this.endpointId()).matches()) {
            throw new IllegalArgumentException("Invalid endpoint ID: '" + this.endpointId() + "'");
        }
    }

    public String endpointId() {
        return this.endpointId.orElse(defaultEndpointId);
    }

    public String containerId() {
        return this.containerId;
    }

    public Set<RegionName> regions() {
        return this.regions;
    }

    public Endpoint withRegions(Set<String> regions) {
        return new Endpoint(this.endpointId, this.containerId, regions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return Objects.equals(this.endpointId, endpoint.endpointId) && Objects.equals(this.containerId, endpoint.containerId) && Objects.equals(this.regions, endpoint.regions);
    }

    public int hashCode() {
        return Objects.hash(this.endpointId, this.containerId, this.regions);
    }

    public String toString() {
        return "endpoint '" + this.endpointId() + "' (cluster " + this.containerId + ") -> " + this.regions.stream().map(RegionName::value).sorted().collect(Collectors.joining(", "));
    }
}

