/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.slime.Type;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

public class Quota {
    private static final Quota UNLIMITED = new Quota(Optional.empty(), Optional.empty());
    private final Optional<Integer> maxClusterSize;
    private final Optional<BigDecimal> budget;

    public Quota(Optional<Integer> maxClusterSize, Optional<Integer> budget) {
        this(maxClusterSize, budget.map(BigDecimal::new), true);
    }

    private Quota(Optional<Integer> maxClusterSize, Optional<BigDecimal> budget, boolean isDecimal) {
        this.maxClusterSize = Objects.requireNonNull(maxClusterSize);
        this.budget = Objects.requireNonNull(budget);
    }

    public static Quota fromSlime(Inspector inspector) {
        Optional clusterSize = SlimeUtils.optionalLong((Inspector)inspector.field("clusterSize"));
        Optional<BigDecimal> budget = Quota.budgetFromSlime(inspector.field("budget"));
        return new Quota(clusterSize.map(Long::intValue), budget, true);
    }

    public Quota withBudget(BigDecimal budget) {
        return new Quota(this.maxClusterSize, Optional.of(budget), true);
    }

    public Quota withClusterSize(int clusterSize) {
        return new Quota(Optional.of(clusterSize), this.budget, true);
    }

    public Slime toSlime() {
        Slime slime = new Slime();
        Cursor root = slime.setObject();
        this.maxClusterSize.ifPresent(clusterSize -> root.setLong("clusterSize", (long)clusterSize.intValue()));
        this.budget.ifPresent(b -> root.setString("budget", b.toPlainString()));
        return slime;
    }

    public static Quota unlimited() {
        return UNLIMITED;
    }

    public Optional<Integer> maxClusterSize() {
        return this.maxClusterSize;
    }

    public Optional<BigDecimal> budgetAsDecimal() {
        return this.budget;
    }

    public static Quota empty() {
        return Quota.unlimited();
    }

    public Optional<Integer> budget() {
        return this.budget.map(BigDecimal::intValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quota quota = (Quota)o;
        return Objects.equals(this.maxClusterSize, quota.maxClusterSize) && Objects.equals(this.budget, quota.budget);
    }

    public int hashCode() {
        return Objects.hash(this.maxClusterSize, this.budget);
    }

    public String toString() {
        return "Quota{maxClusterSize=" + this.maxClusterSize + ", budget=" + this.budget + "}";
    }

    private static Optional<BigDecimal> budgetFromSlime(Inspector inspector) {
        if (inspector.type() == Type.STRING) {
            return Optional.of(inspector.asString()).map(BigDecimal::new);
        }
        if (inspector.type() == Type.LONG) {
            return Optional.of(inspector.asLong()).map(BigDecimal::new);
        }
        if (inspector.type() == Type.DOUBLE) {
            return Optional.of(inspector.asDouble()).map(BigDecimal::new);
        }
        return Optional.empty();
    }
}

