/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ApplicationRoles;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.model.api.Quota;
import com.yahoo.config.model.api.Reindexing;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface ModelContext {
    public ApplicationPackage applicationPackage();

    public Optional<Model> previousModel();

    public Optional<ApplicationPackage> permanentApplicationPackage();

    public HostProvisioner getHostProvisioner();

    public Provisioned provisioned();

    public DeployLogger deployLogger();

    public ConfigDefinitionRepo configDefinitionRepo();

    public FileRegistry getFileRegistry();

    default public Optional<? extends Reindexing> reindexing() {
        return Optional.empty();
    }

    public Properties properties();

    default public Optional<File> appDir() {
        return Optional.empty();
    }

    default public Optional<DockerImage> wantedDockerImageRepo() {
        return Optional.empty();
    }

    public Version modelVespaVersion();

    public Version wantedNodeVespaVersion();

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ModelFeatureFlag {
        public String[] owners();

        public String removeAfter() default "";

        public String comment() default "";
    }

    public static interface Properties {
        public FeatureFlags featureFlags();

        public boolean multitenant();

        public ApplicationId applicationId();

        public List<ConfigServerSpec> configServerSpecs();

        public HostName loadBalancerName();

        public URI ztsUrl();

        public String athenzDnsSuffix();

        public boolean hostedVespa();

        public Zone zone();

        public Set<ContainerEndpoint> endpoints();

        public boolean isBootstrap();

        public boolean isFirstTimeDeployment();

        default public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return Optional.empty();
        }

        default public Optional<AthenzDomain> athenzDomain() {
            return Optional.empty();
        }

        public Optional<ApplicationRoles> applicationRoles();

        default public Quota quota() {
            return Quota.unlimited();
        }

        public String jvmGCOptions();

        default public boolean useDedicatedNodeForLogserver() {
            return true;
        }
    }

    public static interface FeatureFlags {
        @ModelFeatureFlag(owners={"bjorncs", "jonmv"}, removeAfter="7.352")
        default public boolean enableAutomaticReindexing() {
            return true;
        }

        @ModelFeatureFlag(owners={"jonmv"}, removeAfter="7.355")
        default public double reindexerWindowSizeIncrement() {
            return 0.2;
        }

        @ModelFeatureFlag(owners={"baldersheim"}, comment="Revisit in May or June 2021")
        default public double defaultTermwiseLimit() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"vekterli"})
        default public boolean useThreePhaseUpdates() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"}, comment="Select sequencer type use while feeding")
        default public String feedSequencerType() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public String responseSequencerType() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public int defaultNumResponseThreads() {
            return 2;
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public boolean skipCommunicationManagerThread() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public boolean skipMbusRequestThread() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public boolean skipMbusReplyThread() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"tokle"})
        default public boolean useAccessControlTlsHandshakeClientAuth() {
            return false;
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public boolean useAsyncMessageHandlingOnSchedule() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"}, removeAfter="7.350")
        default public int mergeChunkSize() {
            return 0x2000000;
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public double feedConcurrency() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"baldersheim"})
        default public boolean useBucketExecutorForLidSpaceCompact() {
            throw new UnsupportedOperationException("TODO specify default value");
        }

        @ModelFeatureFlag(owners={"musum", "mpolden"}, comment="Revisit in February 2021")
        default public boolean reconfigurableZookeeperServer() {
            return false;
        }

        @ModelFeatureFlag(owners={"bjorncs", "tokle"})
        default public boolean enableJdiscConnectionLog() {
            return false;
        }

        @ModelFeatureFlag(owners={"bjorncs", "tokle", "baldersheim"})
        default public boolean enableZstdCompressionAccessLog() {
            return false;
        }

        @ModelFeatureFlag(owners={"geirst"})
        default public boolean enableFeedBlockInDistributor() {
            return false;
        }

        @ModelFeatureFlag(owners={"baldersheim", "geirst", "toregge"})
        default public double maxDeadBytesRatio() {
            return 0.2;
        }
    }
}

