/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.google.common.collect.ImmutableList;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.ValidationId;
import com.yahoo.io.IOUtils;
import com.yahoo.text.XML;
import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class ValidationOverrides {
    public static final ValidationOverrides empty = new ValidationOverrides((List<Allow>)ImmutableList.of(), "<validation-overrides/>");
    public static final ValidationOverrides all = new AllowAllValidationOverrides();
    private final List<Allow> overrides;
    private final String xmlForm;

    public ValidationOverrides(List<Allow> overrides) {
        this(overrides, null);
    }

    private ValidationOverrides(List<Allow> overrides, String xmlForm) {
        this.overrides = ImmutableList.copyOf(overrides);
        this.xmlForm = xmlForm;
    }

    public void invalid(ValidationId validationId, String message, Instant now) {
        if (!this.allows(validationId, now)) {
            throw new ValidationException(validationId, message);
        }
    }

    public boolean allows(String validationIdString, Instant now) {
        Optional<ValidationId> validationId = ValidationId.from(validationIdString);
        if (!validationId.isPresent()) {
            return false;
        }
        return this.allows(validationId.get(), now);
    }

    public boolean allows(ValidationId validationId, Instant now) {
        for (Allow override : this.overrides) {
            if (now.plus(Duration.ofDays(30L)).isBefore(override.until)) {
                throw new IllegalArgumentException(override + " is too far in the future: Max 30 days is allowed");
            }
            if (!override.allows(validationId, now)) continue;
            return true;
        }
        return false;
    }

    public String xmlForm() {
        return this.xmlForm;
    }

    public static String toAllowMessage(ValidationId id) {
        return "To allow this add <allow until='yyyy-mm-dd'>" + id + "</allow> to validation-overrides.xml, see https://docs.vespa.ai/documentation/reference/validation-overrides.html";
    }

    public static ValidationOverrides fromXml(Reader reader) {
        try {
            return ValidationOverrides.fromXml(IOUtils.readAll((Reader)reader));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read deployment spec", e);
        }
    }

    public static ValidationOverrides fromXml(String xmlForm) {
        if (xmlForm.isEmpty()) {
            return empty;
        }
        try {
            Element root = XML.getDocument((String)xmlForm).getDocumentElement();
            ArrayList<Allow> overrides = new ArrayList<Allow>();
            for (Element allow : XML.getChildren((Element)root, (String)"allow")) {
                Instant until = LocalDate.parse(allow.getAttribute("until"), DateTimeFormatter.ISO_DATE).atStartOfDay().atZone(ZoneOffset.UTC).toInstant().plus(Duration.ofDays(1L));
                Optional<ValidationId> validationId = ValidationId.from(XML.getValue((Element)allow));
                if (!validationId.isPresent()) continue;
                overrides.add(new Allow(validationId.get(), until));
            }
            return new ValidationOverrides(overrides, xmlForm);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("validation-overrides is invalid", e);
        }
    }

    public static class AllowAllValidationOverrides
    extends ValidationOverrides {
        private final DeployLogger logger;
        private final ValidationOverrides wrapped;

        public AllowAllValidationOverrides() {
            this((ValidationOverrides)null, (DeployLogger)null);
        }

        public AllowAllValidationOverrides(ValidationOverrides wrapped, DeployLogger logger) {
            super(List.of());
            this.wrapped = wrapped;
            this.logger = logger;
        }

        @Override
        public void invalid(ValidationId validationId, String message, Instant now) {
            if (this.wrapped != null && this.logger != null && !this.wrapped.allows(validationId, now)) {
                this.logger.log(Level.WARNING, "Possibly destructive change '" + validationId + "' allowed");
            }
        }

        @Override
        public boolean allows(ValidationId validationId, Instant now) {
            return true;
        }

        @Override
        public String xmlForm() {
            return null;
        }

        public String toString() {
            return "(A validation override which allows everything)";
        }
    }

    public static class ValidationException
    extends IllegalArgumentException {
        static final long serialVersionUID = 789984668L;
        private final ValidationId validationId;

        private ValidationException(ValidationId validationId, String message) {
            super(message);
            this.validationId = validationId;
        }

        public ValidationId validationId() {
            return this.validationId;
        }

        @Override
        public String getMessage() {
            return this.validationId + ": " + super.getMessage() + ". " + ValidationOverrides.toAllowMessage(this.validationId);
        }
    }

    public static class Allow {
        private final ValidationId validationId;
        private final Instant until;

        public Allow(ValidationId validationId, Instant until) {
            this.validationId = validationId;
            this.until = until;
        }

        public boolean allows(ValidationId validationId, Instant now) {
            return this.validationId.equals((Object)validationId) && now.isBefore(this.until);
        }

        public String toString() {
            return "allow '" + this.validationId + "' until " + this.until;
        }
    }
}

