/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.model.api;

import com.yahoo.component.Version;
import com.yahoo.config.application.api.ApplicationPackage;
import com.yahoo.config.application.api.DeployLogger;
import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.config.model.api.ApplicationRoles;
import com.yahoo.config.model.api.ConfigDefinitionRepo;
import com.yahoo.config.model.api.ConfigServerSpec;
import com.yahoo.config.model.api.ContainerEndpoint;
import com.yahoo.config.model.api.EndpointCertificateSecrets;
import com.yahoo.config.model.api.HostProvisioner;
import com.yahoo.config.model.api.Model;
import com.yahoo.config.model.api.Provisioned;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostName;
import com.yahoo.config.provision.Zone;
import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public interface ModelContext {
    public ApplicationPackage applicationPackage();

    public Optional<Model> previousModel();

    public Optional<ApplicationPackage> permanentApplicationPackage();

    public Optional<HostProvisioner> hostProvisioner();

    public Provisioned provisioned();

    public DeployLogger deployLogger();

    public ConfigDefinitionRepo configDefinitionRepo();

    public FileRegistry getFileRegistry();

    public Properties properties();

    default public Optional<File> appDir() {
        return Optional.empty();
    }

    default public Optional<DockerImage> wantedDockerImageRepo() {
        return Optional.empty();
    }

    public Version modelVespaVersion();

    public Version wantedNodeVespaVersion();

    public static interface Properties {
        public boolean multitenant();

        public ApplicationId applicationId();

        public List<ConfigServerSpec> configServerSpecs();

        public HostName loadBalancerName();

        public URI ztsUrl();

        public String athenzDnsSuffix();

        public boolean hostedVespa();

        public Zone zone();

        public Set<ContainerEndpoint> endpoints();

        public boolean isBootstrap();

        public boolean isFirstTimeDeployment();

        default public boolean useDedicatedNodeForLogserver() {
            return true;
        }

        default public boolean useAdaptiveDispatch() {
            return true;
        }

        default public Optional<EndpointCertificateSecrets> endpointCertificateSecrets() {
            return Optional.empty();
        }

        public double defaultTermwiseLimit();

        default public int defaultNumResponseThreads() {
            return 1;
        }

        public double threadPoolSizeFactor();

        public double queueSizeFactor();

        default public double defaultSoftStartSeconds() {
            return 0.0;
        }

        default public double defaultTopKProbability() {
            return 0.9999;
        }

        public String docprocLoadBalancerType();

        public String jvmGCOptions();

        public boolean useDistributorBtreeDb();

        public boolean useThreePhaseUpdates();

        default public String proxyProtocol() {
            return "https+proxy-protocol";
        }

        default public Optional<AthenzDomain> athenzDomain() {
            return Optional.empty();
        }

        default public boolean useDedicatedNodesWhenUnspecified() {
            return true;
        }

        public Optional<ApplicationRoles> applicationRoles();

        default public Duration jdiscHealthCheckProxyClientTimeout() {
            return Duration.ofSeconds(1L);
        }
    }
}

