/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.application.api.DeploymentSpec;
import com.yahoo.config.application.api.Endpoint;
import com.yahoo.config.application.api.Notifications;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DeploymentInstanceSpec
extends DeploymentSpec.Step {
    private final InstanceName name;
    private final List<DeploymentSpec.Step> steps;
    private final DeploymentSpec.UpgradePolicy upgradePolicy;
    private final List<DeploymentSpec.ChangeBlocker> changeBlockers;
    private final Optional<String> globalServiceId;
    private final Optional<AthenzDomain> athenzDomain;
    private final Optional<AthenzService> athenzService;
    private final Notifications notifications;
    private final List<Endpoint> endpoints;

    public DeploymentInstanceSpec(InstanceName name, List<DeploymentSpec.Step> steps, DeploymentSpec.UpgradePolicy upgradePolicy, List<DeploymentSpec.ChangeBlocker> changeBlockers, Optional<String> globalServiceId, Optional<AthenzDomain> athenzDomain, Optional<AthenzService> athenzService, Notifications notifications, List<Endpoint> endpoints) {
        this.name = name;
        this.steps = steps;
        this.upgradePolicy = upgradePolicy;
        this.changeBlockers = changeBlockers;
        this.globalServiceId = globalServiceId;
        this.athenzDomain = athenzDomain;
        this.athenzService = athenzService;
        this.notifications = notifications;
        this.endpoints = List.copyOf(this.validateEndpoints(endpoints, this.steps));
        this.validateZones(this.steps);
        this.validateEndpoints(this.steps, globalServiceId, this.endpoints);
        this.validateAthenz();
    }

    public InstanceName name() {
        return this.name;
    }

    private void validateZones(List<DeploymentSpec.Step> steps) {
        HashSet<DeploymentSpec.DeclaredZone> zones = new HashSet<DeploymentSpec.DeclaredZone>();
        for (DeploymentSpec.Step step : steps) {
            for (DeploymentSpec.DeclaredZone zone : step.zones()) {
                this.ensureUnique(zone, zones);
            }
        }
    }

    private void ensureUnique(DeploymentSpec.DeclaredZone zone, Set<DeploymentSpec.DeclaredZone> zones) {
        if (!zones.add(zone)) {
            throw new IllegalArgumentException(zone + " is listed twice in deployment.xml");
        }
    }

    private List<Endpoint> validateEndpoints(List<Endpoint> endpoints, List<DeploymentSpec.Step> steps) {
        Objects.requireNonNull(endpoints, "Missing endpoints parameter");
        Set<String> productionRegions = steps.stream().filter(step -> step.deploysTo(Environment.prod)).flatMap(step -> step.zones().stream()).flatMap(zone -> zone.region().stream()).map(RegionName::value).collect(Collectors.toSet());
        ArrayList<Endpoint> rebuiltEndpointsList = new ArrayList<Endpoint>();
        for (Endpoint endpoint : endpoints) {
            if (endpoint.regions().isEmpty()) {
                Endpoint rebuiltEndpoint = endpoint.withRegions(productionRegions);
                rebuiltEndpointsList.add(rebuiltEndpoint);
                continue;
            }
            rebuiltEndpointsList.add(endpoint);
        }
        return List.copyOf(rebuiltEndpointsList);
    }

    private void validateEndpoints(List<DeploymentSpec.Step> steps, Optional<String> globalServiceId, List<Endpoint> endpoints) {
        if (globalServiceId.isPresent() && !endpoints.isEmpty()) {
            throw new IllegalArgumentException("Providing both 'endpoints' and 'global-service-id'. Use only 'endpoints'.");
        }
        Set stepZones = steps.stream().flatMap(s -> s.zones().stream()).flatMap(z -> z.region().stream()).collect(Collectors.toSet());
        for (Endpoint endpoint : endpoints) {
            for (RegionName endpointRegion : endpoint.regions()) {
                if (stepZones.contains(endpointRegion)) continue;
                throw new IllegalArgumentException("Region used in endpoint that is not declared in 'prod': " + endpointRegion);
            }
        }
    }

    private void validateAthenz() {
        block3: {
            block2: {
                if (!this.athenzDomain.isEmpty()) break block2;
                for (DeploymentSpec.DeclaredZone zone : this.zones()) {
                    if (!zone.athenzService().isPresent()) continue;
                    throw new IllegalArgumentException("Athenz service configured for zone: " + zone + ", but Athenz domain is not configured");
                }
                break block3;
            }
            if (!this.athenzService.isEmpty()) break block3;
            for (DeploymentSpec.DeclaredZone zone : this.zones()) {
                if (!zone.athenzService().isEmpty()) continue;
                throw new IllegalArgumentException("Athenz domain is configured, but Athenz service not configured for zone: " + zone);
            }
        }
    }

    @Override
    public Duration delay() {
        return Duration.ofSeconds(this.steps.stream().mapToLong(step -> step.delay().getSeconds()).sum());
    }

    @Override
    public List<DeploymentSpec.Step> steps() {
        return this.steps;
    }

    public DeploymentSpec.UpgradePolicy upgradePolicy() {
        return this.upgradePolicy;
    }

    public List<DeploymentSpec.ChangeBlocker> changeBlocker() {
        return this.changeBlockers;
    }

    public Optional<String> globalServiceId() {
        return this.globalServiceId;
    }

    public boolean canUpgradeAt(Instant instant) {
        return this.changeBlockers.stream().filter(block -> block.blocksVersions()).noneMatch(block -> block.window().includes(instant));
    }

    public boolean canChangeRevisionAt(Instant instant) {
        return this.changeBlockers.stream().filter(block -> block.blocksRevisions()).noneMatch(block -> block.window().includes(instant));
    }

    @Override
    public List<DeploymentSpec.DeclaredZone> zones() {
        return this.steps.stream().flatMap(step -> step.zones().stream()).collect(Collectors.toList());
    }

    @Override
    public boolean deploysTo(Environment environment, Optional<RegionName> region) {
        for (DeploymentSpec.Step step : this.steps) {
            if (!step.deploysTo(environment, region)) continue;
            return true;
        }
        return false;
    }

    public Optional<AthenzDomain> athenzDomain() {
        return this.athenzDomain;
    }

    public Optional<AthenzService> athenzService(Environment environment, RegionName region) {
        AthenzService athenzService = this.zones().stream().filter(zone -> zone.deploysTo(environment, Optional.of(region))).findFirst().flatMap(DeploymentSpec.DeclaredZone::athenzService).orElse(this.athenzService.orElse(null));
        return Optional.ofNullable(athenzService);
    }

    public Notifications notifications() {
        return this.notifications;
    }

    public List<Endpoint> endpoints() {
        return this.endpoints;
    }

    public boolean includes(Environment environment, Optional<RegionName> region) {
        for (DeploymentSpec.Step step : this.steps) {
            if (!step.deploysTo(environment, region)) continue;
            return true;
        }
        return false;
    }

    DeploymentInstanceSpec withSteps(List<DeploymentSpec.Step> steps) {
        return new DeploymentInstanceSpec(this.name, steps, this.upgradePolicy, this.changeBlockers, this.globalServiceId, this.athenzDomain, this.athenzService, this.notifications, this.endpoints);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentInstanceSpec other = (DeploymentInstanceSpec)o;
        return this.globalServiceId.equals(other.globalServiceId) && this.upgradePolicy == other.upgradePolicy && this.changeBlockers.equals(other.changeBlockers) && this.steps.equals(other.steps) && this.athenzDomain.equals(other.athenzDomain) && this.athenzService.equals(other.athenzService) && this.notifications.equals(other.notifications) && this.endpoints.equals(other.endpoints);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.globalServiceId, this.upgradePolicy, this.changeBlockers, this.steps, this.athenzDomain, this.athenzService, this.notifications, this.endpoints});
    }

    public String toString() {
        return "instance '" + this.name + "'";
    }
}

