/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.config.application.api.DeploymentInstanceSpec;
import com.yahoo.config.application.api.Endpoint;
import com.yahoo.config.application.api.Notifications;
import com.yahoo.config.application.api.TimeWindow;
import com.yahoo.config.application.api.xml.DeploymentSpecXmlReader;
import com.yahoo.config.provision.AthenzDomain;
import com.yahoo.config.provision.AthenzService;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.InstanceName;
import com.yahoo.config.provision.RegionName;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class DeploymentSpec {
    public static final DeploymentSpec empty = new DeploymentSpec(Optional.empty(), UpgradePolicy.defaultPolicy, Optional.empty(), Collections.emptyList(), Collections.emptyList(), "<deployment version='1.0'/>", Optional.empty(), Optional.empty(), Notifications.none(), List.of());
    private final List<Step> steps;
    private final Optional<Integer> majorVersion;
    private final Optional<AthenzDomain> athenzDomain;
    private final Optional<AthenzService> athenzService;
    private final String xmlForm;

    public DeploymentSpec(List<Step> steps, Optional<Integer> majorVersion, Optional<AthenzDomain> athenzDomain, Optional<AthenzService> athenzService, String xmlForm) {
        if (DeploymentSpec.hasSingleInstance(steps)) {
            DeploymentInstanceSpec singleInstance = DeploymentSpec.singleInstance(steps);
            this.steps = List.of(singleInstance.withSteps(DeploymentSpec.completeSteps(singleInstance.steps())));
        } else {
            this.steps = List.copyOf(DeploymentSpec.completeSteps(steps));
        }
        this.majorVersion = majorVersion;
        this.athenzDomain = athenzDomain;
        this.athenzService = athenzService;
        this.xmlForm = xmlForm;
        this.validateTotalDelay(steps);
    }

    public DeploymentSpec(Optional<String> globalServiceId, UpgradePolicy upgradePolicy, Optional<Integer> majorVersion, List<ChangeBlocker> changeBlockers, List<Step> steps, String xmlForm, Optional<AthenzDomain> athenzDomain, Optional<AthenzService> athenzService, Notifications notifications, List<Endpoint> endpoints) {
        this(List.of(new DeploymentInstanceSpec(InstanceName.from((String)"default"), steps, upgradePolicy, changeBlockers, globalServiceId, athenzDomain, athenzService, notifications, endpoints)), majorVersion, athenzDomain, athenzService, xmlForm);
    }

    private static List<Step> completeSteps(List<Step> inputSteps) {
        DeclaredZone stagingStep;
        DeclaredZone testStep;
        ArrayList<Step> steps = new ArrayList<Step>(inputSteps);
        if (steps.stream().anyMatch(step -> step.deploysTo(Environment.prod)) && steps.stream().noneMatch(step -> step.deploysTo(Environment.staging))) {
            steps.add(new DeclaredZone(Environment.staging));
        }
        if (steps.stream().anyMatch(step -> step.deploysTo(Environment.staging)) && steps.stream().noneMatch(step -> step.deploysTo(Environment.test))) {
            steps.add(new DeclaredZone(Environment.test));
        }
        if ((testStep = DeploymentSpec.remove(Environment.test, steps)) != null) {
            steps.add(0, testStep);
        }
        if ((stagingStep = DeploymentSpec.remove(Environment.staging, steps)) != null) {
            steps.add(1, stagingStep);
        }
        return steps;
    }

    private static DeclaredZone remove(Environment environment, List<Step> steps) {
        for (int i = 0; i < steps.size(); ++i) {
            DeclaredZone zoneStep;
            if (!(steps.get(i) instanceof DeclaredZone) || (zoneStep = (DeclaredZone)steps.get(i)).environment() != environment) continue;
            steps.remove(i);
            return zoneStep;
        }
        return null;
    }

    private void validateTotalDelay(List<Step> steps) {
        long totalDelaySeconds = steps.stream().mapToLong(step -> step.delay().getSeconds()).sum();
        if (totalDelaySeconds > Duration.ofHours(24L).getSeconds()) {
            throw new IllegalArgumentException("The total delay specified is " + Duration.ofSeconds(totalDelaySeconds) + " but max 24 hours is allowed");
        }
    }

    private DeploymentInstanceSpec singleInstance() {
        return DeploymentSpec.singleInstance(this.steps);
    }

    private static DeploymentInstanceSpec singleInstance(List<Step> steps) {
        List<DeploymentInstanceSpec> instances = DeploymentSpec.instances(steps);
        if (instances.size() == 1) {
            return instances.get(0);
        }
        throw new IllegalArgumentException("This deployment spec does not support the legacy API as it has multiple instances: " + instances.stream().map(Object::toString).collect(Collectors.joining(",")));
    }

    public Optional<String> globalServiceId() {
        return this.singleInstance().globalServiceId();
    }

    public UpgradePolicy upgradePolicy() {
        return this.singleInstance().upgradePolicy();
    }

    public Optional<Integer> majorVersion() {
        return this.majorVersion;
    }

    public boolean canUpgradeAt(Instant instant) {
        return this.singleInstance().canUpgradeAt(instant);
    }

    public boolean canChangeRevisionAt(Instant instant) {
        return this.singleInstance().canChangeRevisionAt(instant);
    }

    public List<ChangeBlocker> changeBlocker() {
        return this.singleInstance().changeBlocker();
    }

    public List<Step> steps() {
        if (DeploymentSpec.hasSingleInstance(this.steps)) {
            return this.singleInstance().steps();
        }
        return this.steps;
    }

    public List<DeclaredZone> zones() {
        return this.singleInstance().steps().stream().flatMap(step -> step.zones().stream()).collect(Collectors.toList());
    }

    public Optional<AthenzDomain> athenzDomain() {
        return this.athenzDomain;
    }

    public Optional<AthenzService> athenzService(Environment environment, RegionName region) {
        Optional<AthenzService> service = Optional.empty();
        if (DeploymentSpec.hasSingleInstance(this.steps)) {
            service = this.singleInstance().athenzService(environment, region);
        }
        if (service.isPresent()) {
            return service;
        }
        return this.athenzService;
    }

    public Optional<AthenzService> athenzService(InstanceName instanceName, Environment environment, RegionName region) {
        Optional<DeploymentInstanceSpec> instance = this.instance(instanceName);
        if (instance.isEmpty()) {
            return this.athenzService;
        }
        return instance.get().athenzService(environment, region).or(() -> this.athenzService);
    }

    public Notifications notifications() {
        return this.singleInstance().notifications();
    }

    public List<Endpoint> endpoints() {
        return this.singleInstance().endpoints();
    }

    public String xmlForm() {
        return this.xmlForm;
    }

    public boolean includes(Environment environment, Optional<RegionName> region) {
        return this.singleInstance().deploysTo(environment, region);
    }

    private static boolean hasSingleInstance(List<Step> steps) {
        return DeploymentSpec.instances(steps).size() == 1;
    }

    public Optional<DeploymentInstanceSpec> instance(InstanceName name) {
        for (DeploymentInstanceSpec instance : this.instances()) {
            if (!instance.name().equals((Object)name)) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public DeploymentInstanceSpec requireInstance(String name) {
        return this.requireInstance(InstanceName.from((String)name));
    }

    public DeploymentInstanceSpec requireInstance(InstanceName name) {
        Optional<DeploymentInstanceSpec> instance = this.instance(name);
        if (instance.isEmpty()) {
            throw new IllegalArgumentException("No instance '" + name + "' in deployment.xml'. Instances: " + this.instances().stream().map(spec -> spec.name().toString()).collect(Collectors.joining(",")));
        }
        return instance.get();
    }

    public List<InstanceName> instanceNames() {
        return this.instances().stream().map(DeploymentInstanceSpec::name).collect(Collectors.toUnmodifiableList());
    }

    public List<DeploymentInstanceSpec> instances() {
        return DeploymentSpec.instances(this.steps);
    }

    private static List<DeploymentInstanceSpec> instances(List<Step> steps) {
        return steps.stream().flatMap(step -> step instanceof ParallelZones ? ((ParallelZones)step).steps.stream() : List.of(step).stream()).filter(step -> step instanceof DeploymentInstanceSpec).map(DeploymentInstanceSpec.class::cast).collect(Collectors.toList());
    }

    public static DeploymentSpec fromXml(Reader reader) {
        return new DeploymentSpecXmlReader().read(reader);
    }

    public static DeploymentSpec fromXml(String xmlForm) {
        return DeploymentSpec.fromXml(xmlForm, true);
    }

    public static DeploymentSpec fromXml(String xmlForm, boolean validate) {
        return new DeploymentSpecXmlReader(validate).read(xmlForm);
    }

    public static String toMessageString(Throwable t) {
        StringBuilder b = new StringBuilder();
        String lastMessage = null;
        while (t != null) {
            String message = t.getMessage();
            if (message != null && !message.equals(lastMessage)) {
                if (b.length() > 0) {
                    b.append(": ");
                }
                b.append(message);
                lastMessage = message;
            }
            t = t.getCause();
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentSpec other = (DeploymentSpec)o;
        return this.majorVersion.equals(other.majorVersion) && this.steps.equals(other.steps) && this.xmlForm.equals(other.xmlForm);
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.steps, this.xmlForm);
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 3) {
            System.err.println("Usage: DeploymentSpec [file] [environment] [region]?Returns 0 if the specified zone matches the deployment spec, 1 otherwise");
            System.exit(1);
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(args[0]));){
            Optional<RegionName> region;
            DeploymentSpec spec = DeploymentSpec.fromXml(reader);
            Environment environment = Environment.from((String)args[1]);
            Optional<RegionName> optional = region = args.length == 3 ? Optional.of(RegionName.from((String)args[2])) : Optional.empty();
            if (spec.includes(environment, region)) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println("Exception checking deployment spec: " + DeploymentSpec.toMessageString(e));
            System.exit(1);
        }
    }

    public static class ChangeBlocker {
        private final boolean revision;
        private final boolean version;
        private final TimeWindow window;

        public ChangeBlocker(boolean revision, boolean version, TimeWindow window) {
            this.revision = revision;
            this.version = version;
            this.window = window;
        }

        public boolean blocksRevisions() {
            return this.revision;
        }

        public boolean blocksVersions() {
            return this.version;
        }

        public TimeWindow window() {
            return this.window;
        }

        public String toString() {
            return "change blocker revision=" + this.revision + " version=" + this.version + " window=" + this.window;
        }
    }

    public static enum UpgradePolicy {
        canary,
        defaultPolicy,
        conservative;

    }

    public static class ParallelZones
    extends Step {
        private final List<Step> steps;

        public ParallelZones(List<Step> steps) {
            this.steps = List.copyOf(steps);
        }

        @Override
        public List<DeclaredZone> zones() {
            return this.steps.stream().filter(step -> step instanceof DeclaredZone).map(DeclaredZone.class::cast).collect(Collectors.toList());
        }

        @Override
        public List<Step> steps() {
            return this.steps;
        }

        @Override
        public boolean deploysTo(Environment environment, Optional<RegionName> region) {
            return this.steps().stream().anyMatch(zone -> zone.deploysTo(environment, region));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParallelZones)) {
                return false;
            }
            ParallelZones that = (ParallelZones)o;
            return Objects.equals(this.steps, that.steps);
        }

        public int hashCode() {
            return Objects.hash(this.steps);
        }

        public String toString() {
            return this.steps.size() + " parallel steps";
        }
    }

    public static class DeclaredZone
    extends Step {
        private final Environment environment;
        private final Optional<RegionName> region;
        private final boolean active;
        private final Optional<AthenzService> athenzService;
        private final Optional<String> testerFlavor;

        public DeclaredZone(Environment environment) {
            this(environment, Optional.empty(), false);
        }

        public DeclaredZone(Environment environment, Optional<RegionName> region, boolean active) {
            this(environment, region, active, Optional.empty(), Optional.empty());
        }

        public DeclaredZone(Environment environment, Optional<RegionName> region, boolean active, Optional<AthenzService> athenzService) {
            this(environment, region, active, athenzService, Optional.empty());
        }

        public DeclaredZone(Environment environment, Optional<RegionName> region, boolean active, Optional<AthenzService> athenzService, Optional<String> testerFlavor) {
            if (environment != Environment.prod && region.isPresent()) {
                throw new IllegalArgumentException("Non-prod environments cannot specify a region");
            }
            if (environment == Environment.prod && region.isEmpty()) {
                throw new IllegalArgumentException("Prod environments must be specified with a region");
            }
            this.environment = environment;
            this.region = region;
            this.active = active;
            this.athenzService = athenzService;
            this.testerFlavor = testerFlavor;
        }

        public Environment environment() {
            return this.environment;
        }

        public Optional<RegionName> region() {
            return this.region;
        }

        public boolean active() {
            return this.active;
        }

        public Optional<String> testerFlavor() {
            return this.testerFlavor;
        }

        public Optional<AthenzService> athenzService() {
            return this.athenzService;
        }

        @Override
        public List<DeclaredZone> zones() {
            return Collections.singletonList(this);
        }

        @Override
        public boolean deploysTo(Environment environment, Optional<RegionName> region) {
            if (environment != this.environment) {
                return false;
            }
            return !region.isPresent() || region.equals(this.region);
        }

        public int hashCode() {
            return Objects.hash(this.environment, this.region);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeclaredZone)) {
                return false;
            }
            DeclaredZone other = (DeclaredZone)o;
            if (this.environment != other.environment) {
                return false;
            }
            return this.region.equals(other.region());
        }

        public String toString() {
            return this.environment + this.region.map(regionName -> "." + regionName).orElse("");
        }
    }

    public static class Delay
    extends Step {
        private final Duration duration;

        public Delay(Duration duration) {
            this.duration = duration;
        }

        public Duration duration() {
            return this.duration;
        }

        @Override
        public Duration delay() {
            return this.duration;
        }

        @Override
        public boolean deploysTo(Environment environment, Optional<RegionName> region) {
            return false;
        }

        public String toString() {
            return "delay " + this.duration;
        }
    }

    public static abstract class Step {
        public final boolean deploysTo(Environment environment) {
            return this.deploysTo(environment, Optional.empty());
        }

        public abstract boolean deploysTo(Environment var1, Optional<RegionName> var2);

        public List<DeclaredZone> zones() {
            return Collections.emptyList();
        }

        public Duration delay() {
            return Duration.ZERO;
        }

        public List<Step> steps() {
            return List.of();
        }
    }
}

