/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.application.api;

import com.yahoo.path.Path;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public abstract class ApplicationFile
implements Comparable<ApplicationFile> {
    private static final String metaDir = ".meta";
    public static final String ContentStatusNew = "new";
    public static final String ContentStatusChanged = "changed";
    public static final String ContentStatusDeleted = "deleted";
    protected final Path path;
    private static final PathFilter defaultFilter = path1 -> true;

    protected ApplicationFile(Path path) {
        this.path = path;
    }

    public abstract boolean isDirectory();

    public abstract boolean exists();

    public abstract Reader createReader() throws FileNotFoundException;

    public abstract InputStream createInputStream() throws FileNotFoundException;

    public abstract ApplicationFile createDirectory();

    public abstract ApplicationFile writeFile(Reader var1);

    public List<ApplicationFile> listFiles() {
        return this.listFiles(defaultFilter);
    }

    public abstract List<ApplicationFile> listFiles(PathFilter var1);

    public List<ApplicationFile> listFiles(boolean recurse) {
        ArrayList<ApplicationFile> ret = new ArrayList<ApplicationFile>();
        List<ApplicationFile> files = this.listFiles();
        ret.addAll(files);
        if (recurse) {
            for (ApplicationFile file : files) {
                if (!file.isDirectory()) continue;
                ret.addAll(file.listFiles(recurse));
            }
        }
        return ret;
    }

    public abstract ApplicationFile delete();

    public Path getPath() {
        return this.path;
    }

    public String toString() {
        return this.path.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof ApplicationFile) {
            return this.path.equals((Object)((ApplicationFile)other).path);
        }
        return false;
    }

    protected Path getMetaPath() {
        if (this.path.toString().equals("")) {
            return Path.fromString((String)metaDir).append(".root");
        }
        return this.path.getParentPath().append(metaDir).append(this.path.getName());
    }

    public abstract MetaData getMetaData();

    public static interface PathFilter {
        public boolean accept(Path var1);
    }

    public static class MetaData {
        public String status = "unknown";
        public String md5 = "";

        public MetaData() {
        }

        public MetaData(String status, String md5) {
            this.status = status;
            this.md5 = md5;
        }

        public String getStatus() {
            return this.status;
        }

        public String getMd5() {
            return this.md5;
        }
    }
}

