/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.LeafNode;

public class ReferenceNode
extends LeafNode<String> {
    public ReferenceNode() {
    }

    public ReferenceNode(String value) {
        super(true);
        this.value = ReferenceNode.stripQuotes(value);
    }

    @Override
    public String value() {
        return (String)this.value;
    }

    @Override
    public String getValue() {
        return this.value();
    }

    @Override
    public String toString() {
        return this.value == null ? "(null)" : this.getValue();
    }

    @Override
    protected boolean doSetValue(String value) {
        this.value = ReferenceNode.stripQuotes(value);
        return true;
    }

    @Override
    public void postInitialize(String configId) {
        super.postInitialize(configId);
        if (":parent:".equals(this.value())) {
            this.doSetValue(configId);
        }
    }

    static String stripQuotes(String value) {
        if (value == null) {
            return value;
        }
        StringBuffer buffer = new StringBuffer(value.trim());
        if (buffer.length() > 0 && buffer.charAt(0) == '\"') {
            buffer.deleteCharAt(0);
        }
        if (buffer.length() > 0 && buffer.charAt(buffer.length() - 1) == '\"') {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

