/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config;

import com.yahoo.config.FileNode;
import com.yahoo.config.FileReference;
import com.yahoo.config.LeafNode;
import com.yahoo.config.PathNode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class LeafNodeMaps {
    public static <NODE extends LeafNode<REAL>, REAL> Map<String, REAL> asValueMap(Map<String, NODE> input) {
        LinkedHashMap ret = new LinkedHashMap();
        for (String key : input.keySet()) {
            ret.put(key, ((LeafNode)input.get(key)).value());
        }
        return Collections.unmodifiableMap(ret);
    }

    public static <NODE extends LeafNode<REAL>, REAL> Map<String, NODE> asNodeMap(Map<String, REAL> input, NODE defaultNode) {
        LinkedHashMap<String, LeafNode> ret = new LinkedHashMap<String, LeafNode>();
        for (String key : input.keySet()) {
            LeafNode node = (LeafNode)defaultNode.clone();
            node.value = input.get(key);
            ret.put(key, node);
        }
        return Collections.unmodifiableMap(ret);
    }

    public static Map<String, FileNode> asFileNodeMap(Map<String, String> stringMap) {
        LinkedHashMap<String, FileNode> fileNodeMap = new LinkedHashMap<String, FileNode>();
        for (Map.Entry<String, String> e : stringMap.entrySet()) {
            fileNodeMap.put(e.getKey(), new FileNode(e.getValue()));
        }
        return Collections.unmodifiableMap(fileNodeMap);
    }

    public static Map<String, PathNode> asPathNodeMap(Map<String, FileReference> fileReferenceMap) {
        LinkedHashMap<String, PathNode> pathNodeMap = new LinkedHashMap<String, PathNode>();
        for (Map.Entry<String, FileReference> e : fileReferenceMap.entrySet()) {
            pathNodeMap.put(e.getKey(), new PathNode(e.getValue()));
        }
        return Collections.unmodifiableMap(pathNodeMap);
    }
}

