/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa;

import com.yahoo.config.codegen.MakeConfig;
import com.yahoo.config.codegen.MakeConfigProperties;
import com.yahoo.config.codegen.PropertyException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="config-gen", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class ConfigGenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="plugin.configuration.outputDirectory", defaultValue="${project.build.directory}/generated-sources/vespa-configgen-plugin")
    private File outputDirectory;
    @Parameter(property="plugin.configuration.defFilesDirectories", defaultValue="src/main/resources/configdefinitions")
    private String defFilesDirectories;
    @Parameter(property="plugin.configuration.useFramework", defaultValue="true")
    private Boolean useFramework;
    @Parameter(property="plugin.configuration.requireNamespace", defaultValue="true")
    private Boolean requireNamespace;
    @Parameter(property="plugin.configuration.packagePrefix", defaultValue="com.yahoo.")
    private String packagePrefix;
    @Parameter(property="plugin.configuration.testConfig", defaultValue="false")
    private boolean testConfig;

    private List<String> getDefFileNames() {
        ArrayList<String> defFileNames = new ArrayList<String>();
        String[] dirNames = this.defFilesDirectories.split(",");
        ArrayList<File> dirs = new ArrayList<File>();
        for (String dirName : dirNames) {
            File dir = new File(this.project.getBasedir(), dirName.trim());
            if (!dir.isDirectory() || !dir.canRead()) continue;
            dirs.add(dir);
        }
        for (File dir : dirs) {
            String[] dirFiles;
            for (String filename : dirFiles = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".def");
                }
            })) {
                defFileNames.add(dir.toString() + File.separator + filename);
            }
        }
        return defFileNames;
    }

    public void execute() throws MojoExecutionException {
        block7: {
            boolean generateSources;
            List<String> defFileNames = this.getDefFileNames();
            if (defFileNames.size() == 0) {
                return;
            }
            String configSpec = String.join((CharSequence)",", defFileNames);
            File f = this.outputDirectory;
            if (!f.exists()) {
                f.mkdirs();
                generateSources = true;
                this.getLog().debug((CharSequence)"Output dir does not exist");
            } else {
                this.getLog().debug((CharSequence)"Output dir exists");
                generateSources = this.isSomeGeneratedFileStale(this.outputDirectory, defFileNames);
            }
            if (generateSources) {
                this.getLog().debug((CharSequence)"Will generate config class files");
                try {
                    MakeConfigProperties config = new MakeConfigProperties(this.outputDirectory.toString(), configSpec, null, null, null, this.useFramework.toString(), this.packagePrefix);
                    if (!MakeConfig.makeConfig((MakeConfigProperties)config)) {
                        throw new MojoExecutionException("Failed to generate config for: " + configSpec);
                    }
                    break block7;
                }
                catch (PropertyException | IOException e) {
                    throw new MojoExecutionException("Failed to generate config for: " + configSpec, (Exception)e);
                }
            }
            this.getLog().debug((CharSequence)"No changes, will not generate config class files");
        }
        this.addSourceRoot(this.outputDirectory.toString());
    }

    private boolean isSomeGeneratedFileStale(File outputDirectory, List<String> defFileNames) {
        long oldestGeneratedModifiedTime = ConfigGenMojo.walk(outputDirectory.toPath()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).peek(f -> this.getLog().debug((CharSequence)("Checking generated file " + f))).mapToLong(File::lastModified).min().orElse(Long.MAX_VALUE);
        long lastModifiedSource = defFileNames.stream().peek(sourceFile -> this.getLog().debug((CharSequence)("Checking source file " + sourceFile))).map(File::new).mapToLong(File::lastModified).max().orElse(0L);
        this.getLog().debug((CharSequence)("lastModifiedSource: " + lastModifiedSource + ", oldestTGeneratedModified: " + oldestGeneratedModifiedTime));
        return lastModifiedSource > oldestGeneratedModifiedTime;
    }

    private static Stream<Path> walk(Path path) {
        try {
            return Files.walk(path, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void addSourceRoot(String outputDirectory) {
        if (this.testConfig) {
            this.project.addTestCompileSourceRoot(outputDirectory);
        } else {
            this.project.addCompileSourceRoot(outputDirectory);
        }
    }
}

